/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlFlowGraphBuilder;
import com.intellij.sql.dataFlow.instructions.SqlLabel;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.psi.MssqlAlterProcedureStatementImpl;
import com.intellij.sql.dialects.mssql.psi.MssqlTryCatchStatement;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlVisitor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/dialects/mssql/dataFlow/MsDFABuildingVisitor;", "Lcom/intellij/sql/dataFlow/DFABuildingVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "<init>", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)V", "visitSqlAlterStatement", "", "o", "Lcom/intellij/sql/psi/SqlAlterStatement;", "visitSqlBlockStatement", "Lcom/intellij/sql/psi/SqlBlockStatement;", "visitSqlRaiseStatement", "Lcom/intellij/sql/psi/SqlRaiseStatement;", "intellij.database.dialects.mssql"})
public final class MsDFABuildingVisitor
extends DFABuildingVisitor {
    public MsDFABuildingVisitor(@NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        super(dialect);
    }

    public void visitSqlAlterStatement(@NotNull SqlAlterStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (o instanceof MssqlAlterProcedureStatementImpl) {
            this.visitSqlRoutineDefinition((SqlRoutineDefinition)o);
        } else {
            super.visitSqlAlterStatement(o);
        }
    }

    @Override
    public void visitSqlBlockStatement(@NotNull SqlBlockStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (o instanceof MssqlTryCatchStatement) {
            SqlFlowGraphBuilder sqlFlowGraphBuilder = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder);
            sqlFlowGraphBuilder.mark((SqlElement)o);
            SqlFlowGraphBuilder sqlFlowGraphBuilder2 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder2);
            SqlLabel tryStart = sqlFlowGraphBuilder2.newLabel("TRY BLOCK");
            SqlFlowGraphBuilder sqlFlowGraphBuilder3 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder3);
            SqlLabel catchStart = sqlFlowGraphBuilder3.newLabel("CATCH BLOCK");
            SqlFlowGraphBuilder sqlFlowGraphBuilder4 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder4);
            SqlLabel tryEnd = sqlFlowGraphBuilder4.newLabel("TRY END");
            SqlFlowGraphBuilder sqlFlowGraphBuilder5 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder5);
            SqlLabel[] sqlLabelArray = new SqlLabel[]{tryStart, catchStart};
            sqlFlowGraphBuilder5.genNondeterministicJump(CollectionsKt.listOf((Object[])sqlLabelArray));
            SqlFlowGraphBuilder sqlFlowGraphBuilder6 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder6);
            sqlFlowGraphBuilder6.bindLabelToNext(tryStart);
            SqlFlowGraphBuilder sqlFlowGraphBuilder7 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder7);
            sqlFlowGraphBuilder7.enterBlock((SqlElement)o);
            for (PsiElement it : ((MssqlTryCatchStatement)o).getBlockElements()) {
                if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)MsElementTypes.Misc.MSSQL_CATCH_CLAUSE)) continue;
                SqlElement sqlElement = it instanceof SqlElement ? (SqlElement)it : null;
                if (sqlElement == null) continue;
                sqlElement.accept((SqlVisitor)this);
            }
            SqlFlowGraphBuilder sqlFlowGraphBuilder8 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder8);
            sqlFlowGraphBuilder8.genJump(tryEnd);
            SqlFlowGraphBuilder sqlFlowGraphBuilder9 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder9);
            sqlFlowGraphBuilder9.exitBlock((SqlElement)o);
            SqlFlowGraphBuilder sqlFlowGraphBuilder10 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder10);
            sqlFlowGraphBuilder10.bindLabelToNext(catchStart);
            SqlBlockStatement sqlBlockStatement = ((MssqlTryCatchStatement)o).getCatchBlock();
            if (sqlBlockStatement != null) {
                sqlBlockStatement.accept((SqlVisitor)this);
            }
            SqlFlowGraphBuilder sqlFlowGraphBuilder11 = this.getBuilder();
            Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder11);
            sqlFlowGraphBuilder11.bindLabelToNext(tryEnd);
        } else {
            super.visitSqlBlockStatement(o);
        }
    }

    @Override
    public void visitSqlRaiseStatement(@NotNull SqlRaiseStatement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)o.getFirstChild()), (Object)SqlCommonKeywords.SQL_RAISERROR)) {
            SqlExpression[] arguments = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)o), SqlExpression.class);
            Object object = arguments;
            if (object == null || (object = (SqlExpression[])ArraysKt.getOrNull((Object[])object, (int)1)) == null || (object = object.getText()) == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return;
            }
            int severity = (Integer)object;
            if (severity <= 10) {
                return;
            }
        }
        SqlFlowGraphBuilder sqlFlowGraphBuilder = this.getBuilder();
        Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder);
        sqlFlowGraphBuilder.mark((SqlElement)o);
        SqlFlowGraphBuilder sqlFlowGraphBuilder2 = this.getBuilder();
        Intrinsics.checkNotNull((Object)sqlFlowGraphBuilder2);
        sqlFlowGraphBuilder2.genThrow((SqlStatement)o);
    }
}

