/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.sql.SqlBundle;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/inspections/RenamePsiFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.database.sql.impl"})
public final class RenamePsiFix
implements LocalQuickFix,
DumbAware {
    @NotNull
    public static final RenamePsiFix INSTANCE = new RenamePsiFix();

    private RenamePsiFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.rename.element", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getStartElement(...)");
        this.applyFix(psiElement);
    }

    public final void applyFix(@NotNull PsiElement element) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile file = element.getContainingFile();
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
            if (document == null) {
                return;
            }
            Document doc = document;
            Editor editor2 = EditorFactory.getInstance().editors(doc).findFirst().orElse(null);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            editor3.getCaretModel().moveToOffset(element.getTextOffset());
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor3.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (renameHandler == null) break block2;
            renameHandler.invoke(project2, editor3, file, dataContext2);
        }
    }
}

