/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class WhenNode
extends Node {
    protected Node expressionNodes;
    protected Node bodyNode;
    private Node nextCase;

    public WhenNode(SourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        super(position);
        this.expressionNodes = this.adopt(expressionNodes);
        this.bodyNode = this.adopt(bodyNode);
        this.nextCase = this.adopt(nextCase);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        WhenNode other = (WhenNode)node;
        if (this.getBody() == null && other.getBody() == null) {
            if (this.getExpression() == null && other.getExpression() == null) {
                if (this.getNextCase() == null && other.getNextCase() == null) {
                    return true;
                }
                if (this.getNextCase() == null || other.getNextCase() == null) {
                    return false;
                }
                return this.getNextCase().isSame(other.getNextCase());
            }
            if (this.getExpression() == null || other.getExpression() == null) {
                return false;
            }
            if (this.getNextCase() == null && other.getNextCase() == null) {
                return this.getExpression().isSame(other.getExpression());
            }
            if (this.getNextCase() == null || other.getNextCase() == null) {
                return false;
            }
            return this.getNextCase().isSame(other.getNextCase()) && this.getExpression().isSame(other.getExpression());
        }
        if (this.getBody() == null || other.getBody() == null) {
            return false;
        }
        if (this.getExpression() == null && other.getExpression() == null) {
            if (this.getNextCase() == null && other.getNextCase() == null) {
                return this.getExpression().isSame(other.getExpression());
            }
            if (this.getNextCase() == null || other.getNextCase() == null) {
                return false;
            }
            return this.getNextCase().isSame(other.getNextCase()) && this.getBody().isSame(other.getBody());
        }
        if (this.getExpression() == null || other.getExpression() == null) {
            return false;
        }
        if (this.getNextCase() == null && other.getNextCase() == null) {
            return this.getExpression().isSame(other.getExpression()) && this.getBody().isSame(other.getBody());
        }
        if (this.getNextCase() == null || other.getNextCase() == null) {
            return false;
        }
        return this.getNextCase().isSame(other.getNextCase()) && this.getExpression().isSame(other.getExpression()) && this.getBody().isSame(other.getBody());
    }

    public NodeType getNodeType() {
        return NodeType.WHENNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = this.adopt(body);
    }

    public Node getNextCase() {
        return this.nextCase;
    }

    public Node getExpression() {
        return this.expressionNodes;
    }

    @Deprecated
    public Node getExpressionNode() {
        return this.getExpression();
    }

    public void setExpression(Node expression) {
        this.expressionNodes = this.adopt(expression);
    }
}

