/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.util.List;
import java.util.Set;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.MessageRequestResponseType;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;

public class SendMessageRequestResponseCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "sendMessageRequestResponse";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Send response to a message request to linked devices.");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the recipient group ID.").nargs("*");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipients' phone number.").nargs("*");
        subparser.addArgument(new String[]{"-u", "--username"}).help("Specify the recipient username or username link.").nargs("*");
        subparser.addArgument(new String[]{"--type"}).help("Type of message request response").type((ArgumentType)Arguments.enumStringType(MessageRequestResponseType.class)).required(true);
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        MessageRequestResponseType t;
        List recipientStrings = ns.getList("recipient");
        List groupIdStrings = ns.getList("group-id");
        List usernameStrings = ns.getList("username");
        Object typeObj = ns.get("type");
        MessageRequestResponseType type = typeObj instanceof MessageRequestResponseType ? (t = (MessageRequestResponseType)((Object)typeObj)) : MessageRequestResponseType.valueOf(((String)typeObj).toUpperCase());
        Set<RecipientIdentifier> recipientIdentifiers = CommandUtil.getRecipientIdentifiers(m, false, recipientStrings, groupIdStrings, usernameStrings);
        m.sendMessageRequestResponse(type == MessageRequestResponseType.ACCEPT ? MessageEnvelope.Sync.MessageRequestResponse.Type.ACCEPT : MessageEnvelope.Sync.MessageRequestResponse.Type.DELETE, recipientIdentifiers);
    }
}

