/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.clipsrules.jni.CLIPSType;
import net.sf.clipsrules.jni.PrimitiveValue;

public class MultifieldValue
extends PrimitiveValue
implements Iterable<PrimitiveValue> {
    private List<PrimitiveValue> value;

    public MultifieldValue() {
        this.value = new ArrayList<PrimitiveValue>();
    }

    public MultifieldValue(List<PrimitiveValue> list) {
        this.value = list;
    }

    @Override
    public List<PrimitiveValue> getValue() {
        return this.value;
    }

    @Override
    public CLIPSType getCLIPSType() {
        return CLIPSType.MULTIFIELD;
    }

    @Override
    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultifieldValue multifieldValue = (MultifieldValue)object;
        if (this.value == null) {
            return multifieldValue.value == null;
        }
        return this.value.equals(multifieldValue.value);
    }

    public PrimitiveValue get(int n) {
        Object object = this.getValue();
        return (PrimitiveValue)object.get(n);
    }

    public int size() {
        Object object = this.getValue();
        return object.size();
    }

    @Override
    public void retain() {
        Object object = this.getValue();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PrimitiveValue primitiveValue = (PrimitiveValue)iterator.next();
            primitiveValue.retain();
        }
    }

    @Override
    public void release() {
        Object object = this.getValue();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PrimitiveValue primitiveValue = (PrimitiveValue)iterator.next();
            primitiveValue.release();
        }
    }

    @Override
    public String toString() {
        Object object = this.getValue();
        boolean bl = true;
        String string = "(";
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            PrimitiveValue primitiveValue = (PrimitiveValue)iterator.next();
            if (!bl) {
                string = string + " " + primitiveValue;
                continue;
            }
            string = string + primitiveValue;
            bl = false;
        }
        string = string + ")";
        return string;
    }

    @Override
    public Iterator<PrimitiveValue> iterator() {
        return this.getValue().iterator();
    }

    @Override
    public boolean isMultifield() {
        return true;
    }
}

