/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HelpMenu
extends JMenu
implements ActionListener {
    private static final String clipsHomePageAction = "CLIPSHomePage";
    private static final String onlineDocumentationAction = "OnlineDocumentation";
    private static final String onlineExamplesAction = "OnlineExamples";
    private static final String clipsExpertSystemGroupAction = "CLIPSExpertSystemGroup";
    private static final String sourceForgeForumsAction = "SourceForgeForums";
    private static final String stackOverflowQAAction = "StackOverflowQ&A";
    private static final String aboutCLIPSIDEAction = "AboutCLIPSIDE";
    private JMenuItem jmiCLIPSHomePage = null;
    private JMenuItem jmiOnlineDocumentation = null;
    private JMenuItem jmiOnlineExamples = null;
    private JMenuItem jmiCLIPSExpertSystemGroup = null;
    private JMenuItem jmiSourceForgeForums = null;
    private JMenuItem jmiStackOverflowQA = null;
    private JMenuItem jmiAboutCLIPSIDE = null;
    private JFrame parentFrame;

    HelpMenu(JFrame jFrame) {
        super("Help");
        this.parentFrame = jFrame;
        this.jmiCLIPSHomePage = new JMenuItem("CLIPS Home Page");
        this.jmiCLIPSHomePage.setActionCommand(clipsHomePageAction);
        this.jmiCLIPSHomePage.addActionListener(this);
        this.add(this.jmiCLIPSHomePage);
        this.jmiOnlineDocumentation = new JMenuItem("Online Documentation");
        this.jmiOnlineDocumentation.setActionCommand(onlineDocumentationAction);
        this.jmiOnlineDocumentation.addActionListener(this);
        this.add(this.jmiOnlineDocumentation);
        this.jmiOnlineExamples = new JMenuItem("Online Examples");
        this.jmiOnlineExamples.setActionCommand(onlineExamplesAction);
        this.jmiOnlineExamples.addActionListener(this);
        this.add(this.jmiOnlineExamples);
        this.jmiCLIPSExpertSystemGroup = new JMenuItem("CLIPS Expert System Group");
        this.jmiCLIPSExpertSystemGroup.setActionCommand(clipsExpertSystemGroupAction);
        this.jmiCLIPSExpertSystemGroup.addActionListener(this);
        this.add(this.jmiCLIPSExpertSystemGroup);
        this.jmiSourceForgeForums = new JMenuItem("SourceForge Forums");
        this.jmiSourceForgeForums.setActionCommand(sourceForgeForumsAction);
        this.jmiSourceForgeForums.addActionListener(this);
        this.add(this.jmiSourceForgeForums);
        this.jmiStackOverflowQA = new JMenuItem("Stack Overflow Q&A");
        this.jmiStackOverflowQA.setActionCommand(stackOverflowQAAction);
        this.jmiStackOverflowQA.addActionListener(this);
        this.add(this.jmiStackOverflowQA);
        this.addSeparator();
        this.jmiAboutCLIPSIDE = new JMenuItem("About CLIPS IDE");
        this.jmiAboutCLIPSIDE.setActionCommand(aboutCLIPSIDEAction);
        this.jmiAboutCLIPSIDE.addActionListener(this);
        this.add(this.jmiAboutCLIPSIDE);
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals(clipsHomePageAction)) {
            this.openCLIPSHomePage();
        } else if (actionEvent.getActionCommand().equals(onlineDocumentationAction)) {
            this.openOnlineDocumentation();
        } else if (actionEvent.getActionCommand().equals(onlineExamplesAction)) {
            this.openOnlineExamples();
        } else if (actionEvent.getActionCommand().equals(clipsExpertSystemGroupAction)) {
            this.openCLIPSExpertSystemGroup();
        } else if (actionEvent.getActionCommand().equals(sourceForgeForumsAction)) {
            this.openSourceForgeForums();
        } else if (actionEvent.getActionCommand().equals(stackOverflowQAAction)) {
            this.openStackOverflowQA();
        } else if (actionEvent.getActionCommand().equals(aboutCLIPSIDEAction)) {
            this.aboutCLIPSIDE();
        }
    }

    public void openCLIPSHomePage() {
        try {
            HelpMenu.openWebpage(new URL("http://www.clipsrules.net"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openOnlineDocumentation() {
        try {
            HelpMenu.openWebpage(new URL("http://www.clipsrules.net/Documentation.html"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openOnlineExamples() {
        try {
            HelpMenu.openWebpage(new URL("https://sourceforge.net/p/clipsrules/code/HEAD/tree/branches/64x/examples/"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openCLIPSExpertSystemGroup() {
        try {
            HelpMenu.openWebpage(new URL("http://groups.google.com/group/CLIPSESG/"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openSourceForgeForums() {
        try {
            HelpMenu.openWebpage(new URL("http://sourceforge.net/p/clipsrules/discussion"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void openStackOverflowQA() {
        try {
            HelpMenu.openWebpage(new URL("http://stackoverflow.com/questions/tagged/clips"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void openWebpage(URL uRL) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uRI = uRL.toURI();
                desktop.browse(uRI);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void aboutCLIPSIDE() {
        AboutCLIPSIDEDialog aboutCLIPSIDEDialog = new AboutCLIPSIDEDialog(this.parentFrame);
        aboutCLIPSIDEDialog.setLocationRelativeTo(this.parentFrame);
        aboutCLIPSIDEDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class AboutCLIPSIDEDialog
    extends JDialog {
        public AboutCLIPSIDEDialog(JFrame jFrame) {
            Serializable serializable;
            Object object;
            super(jFrame, "About CLIPS IDE", true);
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getRootPane().setBorder(BorderFactory.createEmptyBorder(10, 40, 18, 40));
            try {
                object = this.getClass().getResourceAsStream("/net/sf/clipsrules/jni/examples/ide/resources/CLIPS.png");
                serializable = new JLabel(new ImageIcon(ImageIO.read((InputStream)object)));
                ((JComponent)serializable).setAlignmentX(0.5f);
                this.add((Component)serializable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = new JLabel("CLIPS IDE");
            ((JComponent)object).setAlignmentX(0.5f);
            serializable = ((Component)object).getFont();
            serializable = new Font(((Font)serializable).getFontName(), 1, 18);
            ((JComponent)object).setFont((Font)serializable);
            this.add((Component)object);
            object = new JLabel("Version 6.4");
            ((JComponent)object).setAlignmentX(0.5f);
            serializable = new Font(((Font)serializable).getFontName(), 0, 12);
            ((JComponent)object).setFont((Font)serializable);
            this.add((Component)object);
            this.add(Box.createRigidArea(new Dimension(0, 18)));
            object = new JLabel("Design and Development");
            ((JComponent)object).setAlignmentX(0.5f);
            serializable = new Font(((Font)serializable).getFontName(), 1, 14);
            ((JComponent)object).setFont((Font)serializable);
            this.add((Component)object);
            object = new JLabel("Gary Riley");
            ((JComponent)object).setAlignmentX(0.5f);
            serializable = new Font(((Font)serializable).getFontName(), 0, 14);
            ((JComponent)object).setFont((Font)serializable);
            this.add((Component)object);
            this.add(Box.createRigidArea(new Dimension(0, 18)));
            object = new JLabel("Public Domain Release, February 2021");
            ((JComponent)object).setAlignmentX(0.5f);
            serializable = new Font(((Font)serializable).getFontName(), 0, 12);
            ((JComponent)object).setFont((Font)serializable);
            this.add((Component)object);
            this.add(Box.createRigidArea(new Dimension(0, 18)));
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AboutCLIPSIDEDialog.this.setVisible(false);
                    AboutCLIPSIDEDialog.this.dispose();
                }
            });
            jButton.setAlignmentX(0.5f);
            this.add(jButton);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setResizable(false);
        }
    }
}

