# Change Request

<!--
This template is used to propose and discuss major new features to be added to Podman, Buildah, Skopeo, Netavark, and associated libraries.
The creation of a design document prior to feature implementation is not mandatory, but is encouraged.
Before major features are implemented, a pull request should be opened against the Podman repository with a completed version of this template.
Discussion on the feature will occur in the pull request.
Merging the pull request will constitute approval by project maintainers to proceed with implementation work.
When the feature is completed and merged, this document should be removed to avoid cluttering the repository.
It will remain in the Git history for future retrieval if necessary.
-->

## **Short Summary**

<!--
One to two sentence description of the proposal
-->

## **Objective**

<!--
What is this proposal trying to solve?
Why is it necessary?
-->

## **Detailed Description:**

<!--
How should the feature be implemented?
What considerations are there for the project if this is done?
-->

## **Use cases**

<!--
One or more short descriptions of use cases of the feature once complete.
-->

## **Target Podman Release**

<!--
When is this feature expected to be completed here?
Are there hard deadlines to be aware of?
-->

## **Link(s)**

<!--
A list of links to relevant context.
This can include Github issues describing the problem, related previous pull requests, or any other links that assist in understanding this change.
The use of non-Github issue trackers - e.g. corporate or distribution Jira or Bugzilla instances - is allowed, but we ask that all links here be publicly accessible to ensure full context is available to all.
Including a description with each link is not mandatory but is encouraged.
-->

## **Stakeholders**

<!--
A list of stakeholders who will be affected by this change.
Please check any boxes that apply.
For non-obvious stakeholders, you can add a brief sentence justifying after the checklist, but this is purely optional.
-->
- [ ] Podman Users
- [ ] Podman Developers
- [ ] Buildah Users
- [ ] Buildah Developers
- [ ] Skopeo Users
- [ ] Skopeo Developers
- [ ] Podman Desktop
- [ ] CRI-O
- [ ] Storage library
- [ ] Image library
- [ ] Common library
- [ ] Netavark and aardvark-dns

## ** Assignee(s) **

<!--
These people will lead implementation of the feature and drive it to completion.
This does not have to be a comprehensive list of everyone who will work on the feature, but instead just the technical lead or leads.
-->

## **Impacts**

### **CLI**

<!--
Will there be any impact to the CLI?
Do any options need to be added?
Mocked output is strongly encouraged to help demonstrate the changes.
-->

### **Libpod**

<!--
Will there be any changes to the core container management logic?
-->

### **Others**

<!--
Are there any major impacts not mentioned above?
-->

## **Further Description (Optional):**

<!--
Is there anything not covered above that needs to be mentioned?
-->

## **Test Descriptions (Optional):**

<!--
How will this feature be tested?
Detail which existing test suite or suites will be used (or, if a new suite is required, why this is necessary and how it will be implemented.
Will this change require changes to the CI images (e.g. the inclusion of new packages) to be tested?
-->
