package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneExperiment invokes the airec.CloneExperiment API synchronously
func (client *Client) CloneExperiment(request *CloneExperimentRequest) (response *CloneExperimentResponse, err error) {
	response = CreateCloneExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// CloneExperimentWithChan invokes the airec.CloneExperiment API asynchronously
func (client *Client) CloneExperimentWithChan(request *CloneExperimentRequest) (<-chan *CloneExperimentResponse, <-chan error) {
	responseChan := make(chan *CloneExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneExperimentWithCallback invokes the airec.CloneExperiment API asynchronously
func (client *Client) CloneExperimentWithCallback(request *CloneExperimentRequest, callback func(response *CloneExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneExperimentResponse
		var err error
		defer close(result)
		response, err = client.CloneExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneExperimentRequest is the request struct for api CloneExperiment
type CloneExperimentRequest struct {
	*requests.RoaRequest
	InstanceId   string           `position:"Path" name:"instanceId"`
	DryRun       requests.Boolean `position:"Query" name:"dryRun"`
	SceneId      string           `position:"Path" name:"sceneId"`
	ExperimentId string           `position:"Path" name:"experimentId"`
}

// CloneExperimentResponse is the response struct for api CloneExperiment
type CloneExperimentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateCloneExperimentRequest creates a request to invoke CloneExperiment API
func CreateCloneExperimentRequest() (request *CloneExperimentRequest) {
	request = &CloneExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "CloneExperiment", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiments/[experimentId]/actions/clone", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloneExperimentResponse creates a response to parse from CloneExperiment response
func CreateCloneExperimentResponse() (response *CloneExperimentResponse) {
	response = &CloneExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
