package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchAddThingTopo invokes the iot.BatchAddThingTopo API synchronously
func (client *Client) BatchAddThingTopo(request *BatchAddThingTopoRequest) (response *BatchAddThingTopoResponse, err error) {
	response = CreateBatchAddThingTopoResponse()
	err = client.DoAction(request, response)
	return
}

// BatchAddThingTopoWithChan invokes the iot.BatchAddThingTopo API asynchronously
func (client *Client) BatchAddThingTopoWithChan(request *BatchAddThingTopoRequest) (<-chan *BatchAddThingTopoResponse, <-chan error) {
	responseChan := make(chan *BatchAddThingTopoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchAddThingTopo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchAddThingTopoWithCallback invokes the iot.BatchAddThingTopo API asynchronously
func (client *Client) BatchAddThingTopoWithCallback(request *BatchAddThingTopoRequest, callback func(response *BatchAddThingTopoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchAddThingTopoResponse
		var err error
		defer close(result)
		response, err = client.BatchAddThingTopo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchAddThingTopoRequest is the request struct for api BatchAddThingTopo
type BatchAddThingTopoRequest struct {
	*requests.RpcRequest
	GwProductKey  string                          `position:"Query" name:"GwProductKey"`
	IotInstanceId string                          `position:"Query" name:"IotInstanceId"`
	Ext           string                          `position:"Query" name:"Ext"`
	TopoAddItem   *[]BatchAddThingTopoTopoAddItem `position:"Query" name:"TopoAddItem"  type:"Repeated"`
	GwDeviceName  string                          `position:"Query" name:"GwDeviceName"`
	ApiProduct    string                          `position:"Body" name:"ApiProduct"`
	ApiRevision   string                          `position:"Body" name:"ApiRevision"`
}

// BatchAddThingTopoTopoAddItem is a repeated param struct in BatchAddThingTopoRequest
type BatchAddThingTopoTopoAddItem struct {
	ClientId   string `name:"ClientId"`
	SignMethod string `name:"SignMethod"`
	Sign       string `name:"Sign"`
	DeviceName string `name:"DeviceName"`
	ProductKey string `name:"ProductKey"`
	Timestamp  string `name:"Timestamp"`
}

// BatchAddThingTopoResponse is the response struct for api BatchAddThingTopo
type BatchAddThingTopoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBatchAddThingTopoRequest creates a request to invoke BatchAddThingTopo API
func CreateBatchAddThingTopoRequest() (request *BatchAddThingTopoRequest) {
	request = &BatchAddThingTopoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchAddThingTopo", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchAddThingTopoResponse creates a response to parse from BatchAddThingTopo response
func CreateBatchAddThingTopoResponse() (response *BatchAddThingTopoResponse) {
	response = &BatchAddThingTopoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
