package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDeployPauseType invokes the retailcloud.SetDeployPauseType API synchronously
func (client *Client) SetDeployPauseType(request *SetDeployPauseTypeRequest) (response *SetDeployPauseTypeResponse, err error) {
	response = CreateSetDeployPauseTypeResponse()
	err = client.DoAction(request, response)
	return
}

// SetDeployPauseTypeWithChan invokes the retailcloud.SetDeployPauseType API asynchronously
func (client *Client) SetDeployPauseTypeWithChan(request *SetDeployPauseTypeRequest) (<-chan *SetDeployPauseTypeResponse, <-chan error) {
	responseChan := make(chan *SetDeployPauseTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDeployPauseType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDeployPauseTypeWithCallback invokes the retailcloud.SetDeployPauseType API asynchronously
func (client *Client) SetDeployPauseTypeWithCallback(request *SetDeployPauseTypeRequest, callback func(response *SetDeployPauseTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDeployPauseTypeResponse
		var err error
		defer close(result)
		response, err = client.SetDeployPauseType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDeployPauseTypeRequest is the request struct for api SetDeployPauseType
type SetDeployPauseTypeRequest struct {
	*requests.RpcRequest
	DeployPauseType string           `position:"Query" name:"DeployPauseType"`
	DeployOrderId   requests.Integer `position:"Query" name:"DeployOrderId"`
}

// SetDeployPauseTypeResponse is the response struct for api SetDeployPauseType
type SetDeployPauseTypeResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSetDeployPauseTypeRequest creates a request to invoke SetDeployPauseType API
func CreateSetDeployPauseTypeRequest() (request *SetDeployPauseTypeRequest) {
	request = &SetDeployPauseTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "SetDeployPauseType", "", "")
	request.Method = requests.POST
	return
}

// CreateSetDeployPauseTypeResponse creates a response to parse from SetDeployPauseType response
func CreateSetDeployPauseTypeResponse() (response *SetDeployPauseTypeResponse) {
	response = &SetDeployPauseTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
