package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResources invokes the ros.DescribeResources API synchronously
// api document: https://help.aliyun.com/api/ros/describeresources.html
func (client *Client) DescribeResources(request *DescribeResourcesRequest) (response *DescribeResourcesResponse, err error) {
	response = CreateDescribeResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourcesWithChan invokes the ros.DescribeResources API asynchronously
// api document: https://help.aliyun.com/api/ros/describeresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourcesWithChan(request *DescribeResourcesRequest) (<-chan *DescribeResourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourcesWithCallback invokes the ros.DescribeResources API asynchronously
// api document: https://help.aliyun.com/api/ros/describeresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourcesWithCallback(request *DescribeResourcesRequest, callback func(response *DescribeResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourcesRequest is the request struct for api DescribeResources
type DescribeResourcesRequest struct {
	*requests.RoaRequest
	StackId   string `position:"Path" name:"StackId"`
	StackName string `position:"Path" name:"StackName"`
}

// DescribeResourcesResponse is the response struct for api DescribeResources
type DescribeResourcesResponse struct {
	*responses.BaseResponse
}

// CreateDescribeResourcesRequest creates a request to invoke DescribeResources API
func CreateDescribeResourcesRequest() (request *DescribeResourcesRequest) {
	request = &DescribeResourcesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "DescribeResources", "/stacks/[StackName]/[StackId]/resources", "ROS", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeResourcesResponse creates a response to parse from DescribeResources response
func CreateDescribeResourcesResponse() (response *DescribeResourcesResponse) {
	response = &DescribeResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
