/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int m_type;
    OracleType m_owner;
    long m_pos;
    int m_uptCode;

    public TDSPatch(int n, OracleType oracleType, long l, int n2) throws SQLException {
        this.m_type = n;
        this.m_owner = oracleType;
        this.m_pos = l;
        this.m_uptCode = n2;
    }

    int getType() throws SQLException {
        return this.m_type;
    }

    OracleNamedType getOwner() throws SQLException {
        return (OracleNamedType)this.m_owner;
    }

    long getPosition() throws SQLException {
        return this.m_pos;
    }

    byte getUptTypeCode() throws SQLException {
        return (byte)this.m_uptCode;
    }

    void apply(OracleType oracleType) throws SQLException {
        this.apply(oracleType, -1);
    }

    void apply(OracleType oracleType, int n) throws SQLException {
        if (this.m_type == 0) {
            OracleTypeUPT oracleTypeUPT = (OracleTypeUPT)this.m_owner;
            oracleTypeUPT.m_realType = (OracleTypeADT)oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeUPT.getParent());
                oracleNamedType.setOrder(oracleTypeUPT.getOrder());
            }
        } else if (this.m_type == 1) {
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.m_owner;
            oracleTypeCOLLECTION.m_opcode = n;
            oracleTypeCOLLECTION.m_elemType = oracleType;
            if (oracleType instanceof OracleNamedType) {
                OracleNamedType oracleNamedType = (OracleNamedType)oracleType;
                oracleNamedType.setParent(oracleTypeCOLLECTION);
                oracleNamedType.setOrder(1);
            }
        } else {
            DBError.throwSqlException(1);
        }
    }
}

