/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp;

import de.unkrig.commons.io.HexOutputStream;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.Stoppable;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.net.ReverseProxy;
import de.unkrig.commons.net.ftp.FtpReverseProxy;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataConnectionProxy {
    static final Logger LOGGER = Logger.getLogger(DataConnectionProxy.class.getName());
    private ReverseProxy reverseProxy;
    private static int firstDataConnectionPort = 59000;
    private static int lastDataConnectionPort = 58000;
    private static AtomicInteger nextDataConnectionPort;

    public static void setLocalPortRange(int first, int last) {
        if (nextDataConnectionPort != null) {
            throw new IllegalStateException("'setDataConnectionLocalPortRange()' must not be invoked after the first call to 'start()'");
        }
        firstDataConnectionPort = first;
        lastDataConnectionPort = last;
    }

    public int start(InetAddress bindAddress, InetSocketAddress remoteAddress) throws IOException {
        this.stop();
        if (nextDataConnectionPort == null) {
            nextDataConnectionPort = new AtomicInteger(firstDataConnectionPort);
        }
        int firstTriedPort = -1;
        while (true) {
            int port;
            int n = nextDataConnectionPort.compareAndSet(lastDataConnectionPort, firstDataConnectionPort) ? firstDataConnectionPort : (port = firstDataConnectionPort < lastDataConnectionPort ? nextDataConnectionPort.getAndIncrement() : nextDataConnectionPort.getAndDecrement());
            if (firstTriedPort == -1) {
                firstTriedPort = port;
            }
            try {
                InetSocketAddress endpoint = new InetSocketAddress(bindAddress, port);
                this.reverseProxy = new ReverseProxy(endpoint, 0, remoteAddress, Proxy.NO_PROXY, 20000, new ReverseProxy.ProxyConnectionHandler(){

                    public void handleConnection(InputStream clientIn, OutputStream clientOut, InputStream serverIn, OutputStream serverOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, InetSocketAddress serverLocalSocketAddress, InetSocketAddress serverRemoteSocketAddress, Stoppable stoppable) throws IOException {
                        ThreadUtil.parallel(IoUtil.copyRunnable(clientIn, IoUtil.tee(serverOut, new HexOutputStream(LogUtil.logWriter(FtpReverseProxy.LOGGER, Level.FINER, "> ")))), IoUtil.copyRunnable(serverIn, IoUtil.tee(clientOut, new HexOutputStream(LogUtil.logWriter(FtpReverseProxy.LOGGER, Level.FINER, "< ")))), stoppable);
                    }
                });
                ThreadUtil.runInBackground(this.reverseProxy, Thread.currentThread().getName());
                return port;
            }
            catch (BindException be) {
                if (!be.getMessage().startsWith("Address already in use") || port != firstTriedPort) {
                    throw be;
                }
                LOGGER.fine("Port " + port + " is in use; trying next");
                continue;
            }
            break;
        }
    }

    void stop() {
        if (this.reverseProxy != null) {
            this.reverseProxy.stop();
        }
    }
}

