/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;

public class ThreadBenchmark {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final MessageFormat FORMAT1 = new MessageFormat("Real={0}ms Cpu={1}ns User={2}ns");
    private static final MessageFormat FORMAT2 = new MessageFormat("{0}ms");
    private long realTime = System.currentTimeMillis();
    private long cpuTime;
    private long userTime;

    public ThreadBenchmark() {
        if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
            this.cpuTime = threadMXBean.getCurrentThreadCpuTime();
            this.userTime = threadMXBean.getCurrentThreadUserTime();
        }
    }

    public String getMessage() {
        if (threadMXBean.isCurrentThreadCpuTimeSupported()) {
            return FORMAT1.format(new Object[]{System.currentTimeMillis() - this.realTime, threadMXBean.getCurrentThreadCpuTime() - this.cpuTime, threadMXBean.getCurrentThreadUserTime() - this.userTime});
        }
        return FORMAT2.format(System.currentTimeMillis() - this.realTime);
    }
}

