/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.stringstream;

import de.unkrig.commons.util.ConsumerWhichThrows;
import de.unkrig.commons.util.ProducerWhichThrows;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineUtil {
    private static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");

    private LineUtil() {
    }

    public static ProducerWhichThrows<String, IOException> lineProducer(Reader in) {
        final BufferedReader bufferedReader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        return new ProducerWhichThrows<String, IOException>(){

            @Override
            public String produce() throws IOException {
                return bufferedReader.readLine();
            }
        };
    }

    public static ProducerWhichThrows<String, IOException> lineProducerISO8859_1(InputStream in) {
        return LineUtil.lineProducer(new InputStreamReader(in, CHARSET_ISO_8859_1));
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(final Writer writer) {
        return new ConsumerWhichThrows<String, IOException>(){

            @Override
            public void consume(String line) throws IOException {
                writer.write(line);
                writer.write("\r\n");
                writer.flush();
            }
        };
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumerISO8859_1(OutputStream out) {
        return LineUtil.lineConsumer(new OutputStreamWriter(out, CHARSET_ISO_8859_1));
    }
}

