// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2alpha1

import (
	"context"
	"time"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumBGPNodeConfigsGetter has a method to return a CiliumBGPNodeConfigInterface.
// A group's client should implement this interface.
type CiliumBGPNodeConfigsGetter interface {
	CiliumBGPNodeConfigs() CiliumBGPNodeConfigInterface
}

// CiliumBGPNodeConfigInterface has methods to work with CiliumBGPNodeConfig resources.
type CiliumBGPNodeConfigInterface interface {
	Create(ctx context.Context, ciliumBGPNodeConfig *v2alpha1.CiliumBGPNodeConfig, opts v1.CreateOptions) (*v2alpha1.CiliumBGPNodeConfig, error)
	Update(ctx context.Context, ciliumBGPNodeConfig *v2alpha1.CiliumBGPNodeConfig, opts v1.UpdateOptions) (*v2alpha1.CiliumBGPNodeConfig, error)
	UpdateStatus(ctx context.Context, ciliumBGPNodeConfig *v2alpha1.CiliumBGPNodeConfig, opts v1.UpdateOptions) (*v2alpha1.CiliumBGPNodeConfig, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2alpha1.CiliumBGPNodeConfig, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2alpha1.CiliumBGPNodeConfigList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPNodeConfig, err error)
	CiliumBGPNodeConfigExpansion
}

// ciliumBGPNodeConfigs implements CiliumBGPNodeConfigInterface
type ciliumBGPNodeConfigs struct {
	client rest.Interface
}

// newCiliumBGPNodeConfigs returns a CiliumBGPNodeConfigs
func newCiliumBGPNodeConfigs(c *CiliumV2alpha1Client) *ciliumBGPNodeConfigs {
	return &ciliumBGPNodeConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumBGPNodeConfig, and returns the corresponding ciliumBGPNodeConfig object, and an error if there is any.
func (c *ciliumBGPNodeConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumBGPNodeConfig, err error) {
	result = &v2alpha1.CiliumBGPNodeConfig{}
	err = c.client.Get().
		Resource("ciliumbgpnodeconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumBGPNodeConfigs that match those selectors.
func (c *ciliumBGPNodeConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumBGPNodeConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2alpha1.CiliumBGPNodeConfigList{}
	err = c.client.Get().
		Resource("ciliumbgpnodeconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumBGPNodeConfigs.
func (c *ciliumBGPNodeConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumbgpnodeconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumBGPNodeConfig and creates it.  Returns the server's representation of the ciliumBGPNodeConfig, and an error, if there is any.
func (c *ciliumBGPNodeConfigs) Create(ctx context.Context, ciliumBGPNodeConfig *v2alpha1.CiliumBGPNodeConfig, opts v1.CreateOptions) (result *v2alpha1.CiliumBGPNodeConfig, err error) {
	result = &v2alpha1.CiliumBGPNodeConfig{}
	err = c.client.Post().
		Resource("ciliumbgpnodeconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPNodeConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumBGPNodeConfig and updates it. Returns the server's representation of the ciliumBGPNodeConfig, and an error, if there is any.
func (c *ciliumBGPNodeConfigs) Update(ctx context.Context, ciliumBGPNodeConfig *v2alpha1.CiliumBGPNodeConfig, opts v1.UpdateOptions) (result *v2alpha1.CiliumBGPNodeConfig, err error) {
	result = &v2alpha1.CiliumBGPNodeConfig{}
	err = c.client.Put().
		Resource("ciliumbgpnodeconfigs").
		Name(ciliumBGPNodeConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPNodeConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ciliumBGPNodeConfigs) UpdateStatus(ctx context.Context, ciliumBGPNodeConfig *v2alpha1.CiliumBGPNodeConfig, opts v1.UpdateOptions) (result *v2alpha1.CiliumBGPNodeConfig, err error) {
	result = &v2alpha1.CiliumBGPNodeConfig{}
	err = c.client.Put().
		Resource("ciliumbgpnodeconfigs").
		Name(ciliumBGPNodeConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumBGPNodeConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumBGPNodeConfig and deletes it. Returns an error if one occurs.
func (c *ciliumBGPNodeConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumbgpnodeconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumBGPNodeConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumbgpnodeconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumBGPNodeConfig.
func (c *ciliumBGPNodeConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPNodeConfig, err error) {
	result = &v2alpha1.CiliumBGPNodeConfig{}
	err = c.client.Patch(pt).
		Resource("ciliumbgpnodeconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
