/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/api/core/v1"
)

// VolumeMountStatusApplyConfiguration represents an declarative configuration of the VolumeMountStatus type for use
// with apply.
type VolumeMountStatusApplyConfiguration struct {
	Name              *string                   `json:"name,omitempty"`
	MountPath         *string                   `json:"mountPath,omitempty"`
	ReadOnly          *bool                     `json:"readOnly,omitempty"`
	RecursiveReadOnly *v1.RecursiveReadOnlyMode `json:"recursiveReadOnly,omitempty"`
}

// VolumeMountStatusApplyConfiguration constructs an declarative configuration of the VolumeMountStatus type for use with
// apply.
func VolumeMountStatus() *VolumeMountStatusApplyConfiguration {
	return &VolumeMountStatusApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *VolumeMountStatusApplyConfiguration) WithName(value string) *VolumeMountStatusApplyConfiguration {
	b.Name = &value
	return b
}

// WithMountPath sets the MountPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MountPath field is set to the value of the last call.
func (b *VolumeMountStatusApplyConfiguration) WithMountPath(value string) *VolumeMountStatusApplyConfiguration {
	b.MountPath = &value
	return b
}

// WithReadOnly sets the ReadOnly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReadOnly field is set to the value of the last call.
func (b *VolumeMountStatusApplyConfiguration) WithReadOnly(value bool) *VolumeMountStatusApplyConfiguration {
	b.ReadOnly = &value
	return b
}

// WithRecursiveReadOnly sets the RecursiveReadOnly field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RecursiveReadOnly field is set to the value of the last call.
func (b *VolumeMountStatusApplyConfiguration) WithRecursiveReadOnly(value v1.RecursiveReadOnlyMode) *VolumeMountStatusApplyConfiguration {
	b.RecursiveReadOnly = &value
	return b
}
