/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.ListModelBindable;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractTableAdapter<E>
extends AbstractTableModel
implements ListModelBindable<E> {
    private final ListDataListener changeHandler = this.createChangeHandler();
    private final String[] columnNames;
    private ListModel<E> listModel;

    public AbstractTableAdapter() {
        this((ListModel<E>)null, (String[])null);
    }

    public AbstractTableAdapter(ListModel<E> listModel) {
        this(listModel, (String[])null);
    }

    public AbstractTableAdapter(String ... columnNames) {
        this((ListModel<E>)null, columnNames);
    }

    public AbstractTableAdapter(ListModel<E> listModel, String ... columnNames) {
        this.setListModel(listModel);
        if (columnNames == null || columnNames.length == 0) {
            this.columnNames = null;
        } else {
            this.columnNames = new String[columnNames.length];
            System.arraycopy(columnNames, 0, this.columnNames, 0, columnNames.length);
        }
    }

    @Override
    public ListModel<E> getListModel() {
        return this.listModel;
    }

    @Override
    public void setListModel(ListModel<E> newListModel) {
        ListModel<E> oldListModel = this.getListModel();
        if (oldListModel == newListModel) {
            return;
        }
        if (oldListModel != null) {
            oldListModel.removeListDataListener(this.changeHandler);
        }
        this.listModel = newListModel;
        this.fireTableDataChanged();
        if (newListModel != null) {
            newListModel.addListDataListener(this.changeHandler);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public final int getRowCount() {
        return this.listModel == null ? 0 : this.listModel.getSize();
    }

    public final E getRow(int index) {
        return this.listModel.getElementAt(index);
    }

    protected ListDataListener createChangeHandler() {
        return new ListDataChangeHandler();
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            AbstractTableAdapter.this.fireTableRowsInserted(evt.getIndex0(), evt.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            AbstractTableAdapter.this.fireTableRowsDeleted(evt.getIndex0(), evt.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            AbstractTableAdapter.this.fireTableRowsUpdated(evt.getIndex0(), evt.getIndex1());
        }
    }
}

