/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.icon;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.icon.GlyphIconValue;
import com.jgoodies.common.swing.ScreenScaling;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public final class GlyphIcon
implements Icon {
    private static final int DEFAULT_SIZE = ScreenScaling.toPhysical(24);
    private final Font font;
    private final char character;
    private Color foreground;
    private final int width;
    private final int height;

    public GlyphIcon(GlyphIconValue icon) {
        this(icon, DEFAULT_SIZE);
    }

    public GlyphIcon(GlyphIconValue icon, int size) {
        this(icon, size, null);
    }

    public GlyphIcon(GlyphIconValue icon, Color foreground) {
        this(icon, DEFAULT_SIZE, foreground);
    }

    public GlyphIcon(GlyphIconValue icon, int size, Color foreground) {
        this(icon.getBaseFont().deriveFont((float)size), icon.getCode(), size, foreground);
    }

    private GlyphIcon(Font font, char c, int size, Color foreground) {
        this.font = Preconditions.checkNotNull(font, "The %s must not be null.", "font");
        this.character = Preconditions.checkNotNull(Character.valueOf(c), "The %s must not be null.", "character").charValue();
        this.foreground = foreground;
        Preconditions.checkArgument(size > 0, "The size must be greater than 0.");
        this.width = size;
        this.height = size;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g2.translate(x, y);
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        g2.setFont(this.font);
        if (this.foreground != null) {
            g2.setColor(this.foreground);
        } else {
            Color foreground = c.getForeground();
            if (foreground != null) {
                g2.setColor(foreground);
            }
        }
        g2.drawString(String.valueOf(this.character), 0, this.height);
        g2.setColor(oldColor);
        g2.setFont(oldFont);
        g2.translate(-x, -y);
    }
}

