/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics;

import com.jgoodies.application.Application;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.dialogs.core.Verification;
import java.util.Locale;
import java.util.prefs.Preferences;

public abstract class AbstractPreferencesVerification
implements Verification {
    private final String textKey;
    private final Preferences prefs;
    private final String prefsKey;
    private final boolean selectedDefault;

    protected AbstractPreferencesVerification(String textKey, Preferences prefs, String prefsKey, boolean selectedDefault) {
        this.textKey = Preconditions.checkNotBlank(textKey, "The %s must not be null, empty, or whitespace.", "text key");
        this.prefs = Preconditions.checkNotNull(prefs, "The %s must not be null.", "preferences");
        this.prefsKey = Preconditions.checkNotBlank(prefsKey, "The %s must not be null, empty, or whitespace.", "preferences key");
        this.selectedDefault = selectedDefault;
    }

    protected static Preferences getPreferencesRoot() {
        Preferences userRoot = Application.getInstance().getContext().getUserPreferences();
        return userRoot.node("verification");
    }

    @Override
    public final boolean isSelected() {
        return this.prefs.getBoolean(this.prefsKey, false);
    }

    @Override
    public final void setSelected(boolean selected) {
        this.prefs.putBoolean(this.prefsKey, selected);
    }

    @Override
    public final String getMarkedText() {
        return this.getMarkedText(Locale.getDefault());
    }

    public final String getMarkedText(Locale locale) {
        return this.toDisplayString(this.textKey, locale);
    }

    protected abstract String toDisplayString(String var1, Locale var2);

    public void reset() {
        this.setSelected(this.selectedDefault);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("[");
        this.buildParamString(builder);
        builder.append("]");
        return builder.toString();
    }

    protected void buildParamString(StringBuilder builder) {
        builder.append("textKey=");
        builder.append(this.textKey);
        builder.append("; prefsKey=");
        builder.append(this.prefsKey);
    }
}

