/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.search;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.framework.search.FieldSearchProcessor;
import com.jgoodies.framework.util.Background;
import com.jgoodies.search.CompletionApplicationEvent;
import com.jgoodies.search.CompletionApplicationListener;
import com.jgoodies.search.CompletionManager;
import com.jgoodies.search.CompletionProcessEvent;
import com.jgoodies.search.CompletionProcessListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.text.JTextComponent;

public class FieldSearchModel<V>
extends Bean {
    public static final String PROPERTY_TEXT_VALID = "textValid";
    public static final String PROPERTY_SEARCHING = "searching";
    private static final String KEY_FIND_MODEL = "com.jgoodies.framework.search.FieldSearchModel";
    public static final EscapeAndFocusHandler<?> HANDLER = new EscapeAndFocusHandler();
    private final ValueModel valueModel;
    private final ValueModel textModel;
    private final CompletionManager manager;
    protected final InvalidTextBehavior invalidTextBehavior;
    protected final PropertyChangeListener valueChangeHandler;
    protected final PropertyChangeListener textChangeHandler;
    private boolean searching;
    private boolean textValid;
    protected PendingEditBehavior pendingEditBehavior;
    protected V oldValue;

    public FieldSearchModel(ValueModel valueModel, CompletionManager manager) {
        this(valueModel, manager, InvalidTextBehavior.PERSIST);
    }

    public FieldSearchModel(ValueModel valueModel, CompletionManager manager, InvalidTextBehavior invalidTextBehavior) {
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "valueModel");
        Preconditions.checkNotNull(manager, "The %s must not be null.", "completion manager");
        Preconditions.checkNotNull(invalidTextBehavior, "The %s must not be null.", "invalidTextBehavior");
        Preconditions.checkArgument(manager.getProcessor() instanceof FieldSearchProcessor, "The CompletionManager's CompletionProcessor must implement the FieldSearchProcessor interface.");
        this.valueModel = valueModel;
        this.manager = manager;
        this.invalidTextBehavior = invalidTextBehavior;
        this.textModel = new ValueHolder();
        this.valueChangeHandler = this::onValueChange;
        this.textChangeHandler = this::onTextChange;
        this.searching = false;
        this.textValid = true;
        this.oldValue = this.getValue();
        this.initEventHandling();
    }

    public static <T> FieldSearchModel<T> getFindModel(JTextComponent c) {
        return (FieldSearchModel)c.getClientProperty(KEY_FIND_MODEL);
    }

    public static void setFindModel(JTextComponent c, FieldSearchModel<?> model) {
        c.putClientProperty(KEY_FIND_MODEL, model);
    }

    public CompletionManager getManager() {
        return this.manager;
    }

    public FieldSearchProcessor<V> getProcessor() {
        return (FieldSearchProcessor)this.getManager().getProcessor();
    }

    public ValueModel getTextModel() {
        return this.textModel;
    }

    public String getText() {
        return (String)this.textModel.getValue();
    }

    public void setText(String newText) {
        this.textModel.setValue(newText);
    }

    public ValueModel getValueModel() {
        return this.valueModel;
    }

    public V getValue() {
        return (V)this.valueModel.getValue();
    }

    public void setValue(V newValue) {
        this.valueModel.setValue(newValue);
    }

    public boolean isSearching() {
        return this.searching;
    }

    private void setSearching(boolean b) {
        boolean oldSearching = this.isSearching();
        this.searching = b;
        this.firePropertyChange(PROPERTY_SEARCHING, oldSearching, b);
    }

    public boolean isTextValid() {
        return this.textValid;
    }

    private void setTextValid(boolean b) {
        boolean oldTextValid = this.isTextValid();
        this.textValid = b;
        this.firePropertyChange(PROPERTY_TEXT_VALID, oldTextValid, b);
    }

    private void initEventHandling() {
        this.valueModel.addValueChangeListener(this.valueChangeHandler);
        this.textModel.addValueChangeListener(this.textChangeHandler);
        CompletionHandler handler = new CompletionHandler(this);
        this.manager.addCompletionApplicationListener(handler);
        this.manager.addCompletionProcessListener(handler);
        this.updateText();
    }

    protected void setValueSilently(V value) {
        this.valueModel.removeValueChangeListener(this.valueChangeHandler);
        try {
            this.setValue(value);
        }
        finally {
            this.valueModel.addValueChangeListener(this.valueChangeHandler);
        }
    }

    protected void updateText() {
        this.textModel.removeValueChangeListener(this.textChangeHandler);
        try {
            this.setText(this.getProcessor().getDisplayString(this.getValue()));
            this.setTextValid(true);
            this.pendingEditBehavior = PendingEditBehavior.NONE;
        }
        finally {
            this.textModel.addValueChangeListener(this.textChangeHandler);
        }
    }

    public void updateValue() {
        switch (this.pendingEditBehavior) {
            case NONE: {
                return;
            }
            case SEARCH_VALUE: {
                if (this.representsValue(this.getText(), this.getValue())) {
                    this.updateText();
                } else {
                    this.setSearching(true);
                    Object value = Background.get(() -> this.getProcessor().searchValue(this.getText()));
                    this.commitSearchValue(value);
                    this.setSearching(false);
                }
                return;
            }
            case UPDATE_TEXT: {
                this.updateText();
                return;
            }
            case HANDLE_INVALID_TEXT: {
                this.handleInvalidText();
                return;
            }
        }
        throw new IllegalStateException("Unknown FocusLostBehavior: " + (Object)((Object)this.pendingEditBehavior));
    }

    protected void commitValueForCompletion(V value) {
        this.setValueSilently(value);
        this.oldValue = value;
        this.pendingEditBehavior = PendingEditBehavior.UPDATE_TEXT;
    }

    protected void commitSearchValue(V value) {
        boolean validText;
        boolean bl = validText = value != null || this.representsValue(this.getText(), null);
        if (validText) {
            this.setValueSilently(value);
            this.updateText();
        } else {
            this.handleInvalidText();
        }
    }

    protected void handleInvalidText() {
        switch (this.invalidTextBehavior) {
            case REVERT: {
                this.revertValue(null);
                break;
            }
            case PERSIST: {
                this.setValueSilently(null);
                this.setTextValid(false);
                break;
            }
            case NULL: {
                this.setValue(null);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown InvalidTextBehavior: " + (Object)((Object)this.invalidTextBehavior));
            }
        }
    }

    protected boolean revertValue(JTextComponent c) {
        if (this.oldValue == this.getValue()) {
            return false;
        }
        this.setValueSilently(this.oldValue);
        if (this.representsValue(this.getText(), this.oldValue)) {
            this.setTextValid(true);
            return true;
        }
        if (c == null) {
            this.updateText();
            return true;
        }
        this.getManager().deactivate();
        try {
            this.updateText();
        }
        finally {
            this.getManager().activate(c);
        }
        c.selectAll();
        return true;
    }

    private boolean representsValue(String text, V value) {
        return this.getProcessor().represents(text, value);
    }

    private void onValueChange(PropertyChangeEvent evt) {
        this.oldValue = this.getValue();
        this.updateText();
    }

    private void onTextChange(PropertyChangeEvent evt) {
        this.setTextValid(true);
        this.pendingEditBehavior = PendingEditBehavior.SEARCH_VALUE;
    }

    private static final class CompletionHandler<V>
    implements CompletionApplicationListener,
    CompletionProcessListener {
        private final FieldSearchModel<V> model;

        CompletionHandler(FieldSearchModel<V> model) {
            this.model = model;
        }

        @Override
        public void completionApplied(CompletionApplicationEvent event) {
            JTextComponent component = event.getTextComponent();
            FieldSearchModel eventModel = FieldSearchModel.getFindModel(component);
            Preconditions.checkState(eventModel != null, "Missing model for field: %s", component);
            if (this.model != eventModel) {
                return;
            }
            ((FieldSearchModel)this.model).setSearching(true);
            Object value = Background.get(() -> this.model.getProcessor().valueFor(event.getCompletion()));
            ((FieldSearchModel)this.model).setSearching(false);
            this.model.commitValueForCompletion(value);
        }

        @Override
        public boolean searchAllowed(JTextComponent c) {
            FieldSearchModel eventModel = FieldSearchModel.getFindModel(c);
            Preconditions.checkState(eventModel != null, "Missing model for field: %s", c);
            if (this.model != eventModel) {
                return true;
            }
            if (Strings.isBlank(this.model.getText())) {
                return true;
            }
            boolean valueAlreadyPresented = ((FieldSearchModel)this.model).representsValue(this.model.getText(), this.model.getValue()) && (this.model.pendingEditBehavior == PendingEditBehavior.UPDATE_TEXT || this.model.pendingEditBehavior == PendingEditBehavior.NONE);
            return !valueAlreadyPresented;
        }

        @Override
        public void completionProcessed(CompletionProcessEvent event) {
            JTextComponent component = event.getTextComponent();
            FieldSearchModel eventModel = FieldSearchModel.getFindModel(component);
            Preconditions.checkState(eventModel != null, "Missing model for field: %s", component);
            if (this.model != eventModel) {
                return;
            }
            switch (event.getState()) {
                case STARTED: {
                    ((FieldSearchModel)this.model).setSearching(true);
                    break;
                }
                case CANCELLED: {
                    ((FieldSearchModel)this.model).setSearching(false);
                    this.model.pendingEditBehavior = PendingEditBehavior.SEARCH_VALUE;
                    break;
                }
                case SUCCEEDED: {
                    ((FieldSearchModel)this.model).setSearching(false);
                    if (event.hasCompletions()) {
                        ((FieldSearchModel)this.model).setTextValid(true);
                        this.model.pendingEditBehavior = PendingEditBehavior.SEARCH_VALUE;
                        break;
                    }
                    ((FieldSearchModel)this.model).setTextValid(false);
                    this.model.setValueSilently(null);
                    this.model.pendingEditBehavior = PendingEditBehavior.HANDLE_INVALID_TEXT;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknow completion process state: " + (Object)((Object)event.getState()));
                }
            }
        }
    }

    private static final class EscapeAndFocusHandler<T>
    implements FocusListener,
    KeyListener {
        private EscapeAndFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            boolean activation;
            boolean bl = activation = e.getOppositeComponent() == null;
            if (!activation) {
                FieldSearchModel<T> model = EscapeAndFocusHandler.getFindModel(e);
                model.oldValue = model.getValue();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            FieldSearchModel<T> model = EscapeAndFocusHandler.getFindModel(e);
            model.getManager().onFocusLost();
            model.updateValue();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean changed;
            if (e.getKeyCode() == 27 && (changed = EscapeAndFocusHandler.getFindModel(e).revertValue((JTextComponent)e.getSource()))) {
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private static <T> FieldSearchModel<T> getFindModel(EventObject e) {
            JTextComponent c = (JTextComponent)e.getSource();
            return FieldSearchModel.getFindModel(c);
        }
    }

    public static enum InvalidTextBehavior {
        PERSIST,
        REVERT,
        NULL;

    }

    private static enum PendingEditBehavior {
        SEARCH_VALUE,
        UPDATE_TEXT,
        HANDLE_INVALID_TEXT,
        NONE;

    }
}

