/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.sandbox.util;

import com.jgoodies.application.Application;
import com.jgoodies.application.DefaultResourceManager;
import com.jgoodies.application.ResourceMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public final class PackageResourceManager
extends DefaultResourceManager {
    private final Map<Package, String> moduleBundleBaseNames = new HashMap<Package, String>();
    private final Map<Package, ResourceMap> moduleResourceMapCache = Collections.synchronizedMap(new WeakHashMap());

    public PackageResourceManager(Class<? extends Application> applicationClass) {
        super(applicationClass);
    }

    public void registerModule(Package moduleRootPackage) {
        this.registerModule(moduleRootPackage, PackageResourceManager.defaultModuleBundleBaseName(moduleRootPackage));
    }

    public void registerModule(Package moduleRootPackage, String moduleBundleBaseName) {
        this.moduleBundleBaseNames.put(moduleRootPackage, moduleBundleBaseName);
    }

    @Override
    public ResourceMap getResourceMap(Class<?> type) {
        if (type == null) {
            return super.getResourceMap(type);
        }
        this.ensureValidCache();
        Package modulePackage = this.getModulePackageFor(type);
        if (modulePackage == null) {
            return super.getResourceMap(type);
        }
        ResourceMap resourceMap = this.moduleResourceMapCache.get(modulePackage);
        if (resourceMap != null) {
            return resourceMap;
        }
        ResourceMap parentMap = this.getResourceMap();
        ResourceMap moduleResourceMap = this.createResourceMap(parentMap, modulePackage, type);
        resourceMap = moduleResourceMap.getBundle() == null ? parentMap : moduleResourceMap;
        this.moduleResourceMapCache.put(modulePackage, resourceMap);
        return resourceMap;
    }

    @Override
    public void clear() {
        super.clear();
        this.moduleResourceMapCache.clear();
    }

    private Package getModulePackageFor(Class<?> type) {
        String classPackageName = type.getPackage().getName();
        return this.moduleBundleBaseNames.keySet().stream().filter(moduleRootPackage -> classPackageName.startsWith(moduleRootPackage.getName())).findAny().orElse(null);
    }

    private ResourceMap createResourceMap(ResourceMap parent, Package moduleRootPackage, Class<?> type) {
        return this.createResourceMap(parent, this.moduleBundleBaseNames.get(moduleRootPackage), Locale.getDefault(), type.getClassLoader());
    }

    private static String defaultModuleBundleBaseName(Package moduleRootPackage) {
        return moduleRootPackage.getName() + ".resources.Module";
    }
}

