#ifndef THREADPOOL_H
#define THREADPOOL_H

/*
*         OpenPBS (Portable Batch System) v2.3 Software License
*
* Copyright (c) 1999-2010 Veridian Information Solutions, Inc.
* All rights reserved.
*
* ---------------------------------------------------------------------------
* For a license to use or redistribute the OpenPBS software under conditions
* other than those described below, or to purchase support for this software,
* please contact Veridian Systems, PBS Products Department ("Licensor") at:
*
*    www.OpenPBS.org  +1 650 967-4675                  sales@OpenPBS.org
*                        877 902-4PBS (US toll-free)
* ---------------------------------------------------------------------------
*
* This license covers use of the OpenPBS v2.3 software (the "Software") at
* your site or location, and, for certain users, redistribution of the
* Software to other sites and locations.  Use and redistribution of
* OpenPBS v2.3 in source and binary forms, with or without modification,
* are permitted provided that all of the following conditions are met.
* After December 31, 2001, only conditions 3-6 must be met:
*
* 1. Commercial and/or non-commercial use of the Software is permitted
*    provided a current software registration is on file at www.OpenPBS.org.
*    If use of this software contributes to a publication, product, or
*    service, proper attribution must be given; see www.OpenPBS.org/credit.html
*
* 2. Redistribution in any form is only permitted for non-commercial,
*    non-profit purposes.  There can be no charge for the Software or any
*    software incorporating the Software.  Further, there can be no
*    expectation of revenue generated as a consequence of redistributing
*    the Software.
*
* 3. Any Redistribution of source code must retain the above copyright notice
*    and the acknowledgment contained in paragraph 6, this list of conditions
*    and the disclaimer contained in paragraph 7.
*
* 4. Any Redistribution in binary form must reproduce the above copyright
*    notice and the acknowledgment contained in paragraph 6, this list of
*    conditions and the disclaimer contained in paragraph 7 in the
*    documentation and/or other materials provided with the distribution.
*
* 5. Redistributions in any form must be accompanied by information on how to
*    obtain complete source code for the OpenPBS software and any
*    modifications and/or additions to the OpenPBS software.  The source code
*    must either be included in the distribution or be available for no more
*    than the cost of distribution plus a nominal fee, and all modifications
*    and additions to the Software must be freely redistributable by any party
*    (including Licensor) without restriction.
*
* 6. All advertising materials mentioning features or use of the Software must
*    display the following acknowledgment:
*
*     "This product includes software developed by NASA Ames Research Center,
*     Lawrence Livermore National Laboratory, and Veridian Information
*     Solutions, Inc.
*     Visit www.OpenPBS.org for OpenPBS software support,
*     products, and information."
*
* 7. DISCLAIMER OF WARRANTY
*
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT
* ARE EXPRESSLY DISCLAIMED.
*
* IN NO EVENT SHALL VERIDIAN CORPORATION, ITS AFFILIATED COMPANIES, OR THE
* U.S. GOVERNMENT OR ANY OF ITS AGENCIES BE LIABLE FOR ANY DIRECT OR INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/







#include <pthread.h>


#define POOL_DESTROY 0x1



typedef struct tp_work tp_work_t;
struct tp_work
  {
  tp_work_t *next;
  void      *(*work_func)(void *); /* function to call */
  void      *work_arg; /* argument */
  };




typedef struct tp_working tp_working_t;
struct tp_working
  {
  tp_working_t *next;
  pthread_t     working_id; /* id of thread currently working */
  };




typedef struct threadpool threadpool_t;
struct threadpool
  {
  pthread_mutex_t  tp_mutex;
  pthread_cond_t   tp_waiting_work; /* what waiting threads pend on */
  pthread_cond_t   tp_can_destroy; /* thread pool is ready to be deleted */
  tp_working_t    *tp_active;  /* list of currently working threads */
  tp_work_t       *tp_first; /* first in queue */
  tp_work_t       *tp_last;  /* last in queue */
  pthread_attr_t   tp_attr; /* attributes for workers */
  int              tp_nthreads; /* number of threads */
  int              tp_min_threads; /* minimum number of threads */
  int              tp_max_threads; /* maximum number of threads */
  int              tp_idle_threads; /* number of currently idle threads */
  int              tp_max_idle_secs; /* number of seconds before a thread terminates */
  int              tp_flags; /* pool state flags */
  unsigned char    tp_started; /* once this is TRUE begin processing */
  };




extern threadpool_t *request_pool;
extern threadpool_t *task_pool;
extern threadpool_t *async_pool;

int  enqueue_threadpool_request(void *(*func)(void *), void *arg, threadpool_t *tp);
int  initialize_threadpool(threadpool_t **,int,int,int);
void destroy_request_pool(threadpool_t *tp);
void start_request_pool(threadpool_t *tp);
bool threadpool_is_too_busy(threadpool_t *tp, int permissions);


#endif /* ndef THREADPOOL_H */ 

