/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.utils.jars;

import io.bazel.kotlin.builder.utils.jars.JarHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u0014\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0006\u0010\u001a\u001a\u00020\u0011J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/bazel/kotlin/builder/utils/jars/JarCreator;", "Lio/bazel/kotlin/builder/utils/jars/JarHelper;", "Ljava/io/Closeable;", "path", "Ljava/nio/file/Path;", "normalize", "", "verbose", "(Ljava/nio/file/Path;ZZ)V", "injectingRuleKind", "", "jarEntries", "Ljava/util/TreeMap;", "mainClass", "manifestFile", "targetLabel", "addDirectory", "", "directory", "addEntry", "entryName", "fileName", "addRootEntries", "entries", "", "close", "execute", "manifestContent", "", "manifestContentImpl", "manifest", "Ljava/util/jar/Manifest;", "setJarOwner", "setMainClass", "setManifestFile", "src_main_kotlin_io_bazel_kotlin_builder_utils_jars-jars"})
public final class JarCreator
extends JarHelper
implements Closeable {
    @NotNull
    private final TreeMap<String, Path> jarEntries;
    @Nullable
    private String manifestFile;
    @Nullable
    private String mainClass;
    @Nullable
    private String targetLabel;
    @Nullable
    private String injectingRuleKind;

    public JarCreator(@NotNull Path path, boolean normalize, boolean verbose) {
        Intrinsics.checkNotNullParameter(path, "path");
        super(path, normalize, verbose, false, 8, null);
        this.jarEntries = new TreeMap();
    }

    public /* synthetic */ JarCreator(Path path, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(path, bl, bl2);
    }

    private final boolean addEntry(String entryName, Path path) {
        String normalizedEntryName = entryName;
        if (StringsKt.startsWith$default(normalizedEntryName, "/", false, 2, null)) {
            String string = normalizedEntryName.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            normalizedEntryName = string;
        } else if (normalizedEntryName.length() >= 3 && Character.isLetter(normalizedEntryName.charAt(0)) && normalizedEntryName.charAt(1) == ':' && (normalizedEntryName.charAt(2) == '\\' || normalizedEntryName.charAt(2) == '/')) {
            String string = normalizedEntryName.substring(3);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            normalizedEntryName = string;
        } else if (StringsKt.startsWith$default(normalizedEntryName, "./", false, 2, null)) {
            String string = normalizedEntryName.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            normalizedEntryName = string;
        }
        return this.jarEntries.put(normalizedEntryName, path) == null;
    }

    public final boolean addEntry(@NotNull String entryName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Path path = Paths.get(fileName, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(fileName)");
        return this.addEntry(entryName, path);
    }

    public final void addDirectory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter(directory, "directory");
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory does not exist: " + directory);
        }
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(directory, this){
                final /* synthetic */ Path $directory;
                final /* synthetic */ JarCreator this$0;
                {
                    this.$directory = $directory;
                    this.this$0 = $receiver;
                }

                @NotNull
                public FileVisitResult preVisitDirectory(@NotNull Path path, @NotNull BasicFileAttributes attrs) throws IOException {
                    Intrinsics.checkNotNullParameter(path, "path");
                    Intrinsics.checkNotNullParameter(attrs, "attrs");
                    if (!Intrinsics.areEqual(path, this.$directory)) {
                        this.addEntry(path, true);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) throws IOException {
                    Intrinsics.checkNotNullParameter(path, "path");
                    Intrinsics.checkNotNullParameter(attrs, "attrs");
                    this.addEntry(path, false);
                    return FileVisitResult.CONTINUE;
                }

                public final void addEntry(@NotNull Path path, boolean isDirectory) {
                    Intrinsics.checkNotNullParameter(path, "path");
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (Path entry : this.$directory.relativize(path)) {
                        if (!first) {
                            sb.append('/');
                        }
                        sb.append(entry.getFileName());
                        first = false;
                    }
                    if (isDirectory) {
                        sb.append('/');
                    }
                    Map map = JarCreator.access$getJarEntries$p(this.this$0);
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
                    map.put(string, path);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void addRootEntries(@NotNull Collection<String> entries) {
        Intrinsics.checkNotNullParameter(entries, "entries");
        for (String entry : entries) {
            Path path = Paths.get(entry, new String[0]);
            Map map = this.jarEntries;
            String string = ((Object)path.getFileName()).toString();
            Intrinsics.checkNotNullExpressionValue(path, "path");
            map.put(string, path);
        }
    }

    public final void setMainClass(@NotNull String mainClass) {
        Intrinsics.checkNotNullParameter(mainClass, "mainClass");
        this.mainClass = mainClass;
    }

    public final void setJarOwner(@NotNull String targetLabel, @NotNull String injectingRuleKind) {
        Intrinsics.checkNotNullParameter(targetLabel, "targetLabel");
        Intrinsics.checkNotNullParameter(injectingRuleKind, "injectingRuleKind");
        this.targetLabel = targetLabel;
        this.injectingRuleKind = injectingRuleKind;
    }

    public final void setManifestFile(@NotNull String manifestFile) {
        Intrinsics.checkNotNullParameter(manifestFile, "manifestFile");
        this.manifestFile = manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] manifestContent() throws IOException {
        if (this.manifestFile != null) {
            String string = this.manifestFile;
            Intrinsics.checkNotNull(string);
            Closeable closeable = new FileInputStream(string);
            Throwable throwable = null;
            try {
                FileInputStream in = (FileInputStream)closeable;
                boolean bl = false;
                byte[] byArray = this.manifestContentImpl(new Manifest(in));
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        return this.manifestContentImpl(new Manifest());
    }

    private final byte[] manifestContentImpl(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue(attributes, "attributes");
        ((Map)attributes).put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Attributes.Name createdBy = new Attributes.Name("Created-By");
        if (attributes.getValue(createdBy) == null) {
            ((Map)attributes).put(createdBy, "io.bazel.rules.kotlin");
        }
        if (this.mainClass != null) {
            ((Map)attributes).put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.targetLabel != null) {
            ((Map)attributes).put(JarHelper.Companion.getTARGET_LABEL(), this.targetLabel);
        }
        if (this.injectingRuleKind != null) {
            ((Map)attributes).put(JarHelper.Companion.getINJECTING_RULE_KIND(), this.injectingRuleKind);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manifest.write(out);
        byte[] byArray = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "out.toByteArray()");
        return byArray;
    }

    @Override
    public void close() {
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws IOException {
        Closeable closeable = Files.newOutputStream(this.getJarPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new BufferedOutputStream(os);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream bos = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new JarOutputStream(bos);
                Throwable throwable3 = null;
                try {
                    JarOutputStream out = (JarOutputStream)closeable3;
                    boolean bl3 = false;
                    this.writeManifestEntry(out, this.manifestContent());
                    for (Map.Entry entry : ((Map)this.jarEntries).entrySet()) {
                        String key = (String)entry.getKey();
                        Path value = (Path)entry.getValue();
                        this.copyEntry(out, key, value);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally(closeable3, throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static final /* synthetic */ TreeMap access$getJarEntries$p(JarCreator $this) {
        return $this.jarEntries;
    }
}

