/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.cachebench.reportgenerators.CsvBaseReportGenerator;
import org.cachebench.tests.results.StatisticTestResult;
import org.cachebench.tests.results.TestResult;

public class CsvStatisticReportGenerator
extends CsvBaseReportGenerator {
    public CsvStatisticReportGenerator() {
        log = LogFactory.getLog(this.getClass());
    }

    protected void writeTestResult(TestResult results, BufferedWriter writer) throws IOException {
        StatisticTestResult stResults = (StatisticTestResult)results;
        log.debug((Object)"Writing the Result to the Report");
        StringBuffer buf = new StringBuffer();
        if (stResults.isTestPassed()) {
            DescriptiveStatistics putData = stResults.getPutData();
            DescriptiveStatistics getData = stResults.getGetData();
            buf.append(stResults.getTestName());
            buf.append(",");
            buf.append(stResults.getTestTime());
            buf.append(",");
            buf.append(stResults.getTestType());
            buf.append(",");
            buf.append(stResults.getNumMembers());
            buf.append(",");
            buf.append(stResults.getNumThreads());
            buf.append(",");
            buf.append(putData.getSum() / 1000.0);
            buf.append(",");
            buf.append(getData.getSum() / 1000.0);
            buf.append(",");
            buf.append(putData.getMean());
            buf.append(",");
            buf.append(getData.getMean());
            buf.append(",");
            buf.append(putData.getPercentile(50.0));
            buf.append(",");
            buf.append(getData.getPercentile(50.0));
            buf.append(",");
            buf.append(putData.getStandardDeviation());
            buf.append(",");
            buf.append(getData.getStandardDeviation());
            buf.append(",");
            buf.append(putData.getMax());
            buf.append(",");
            buf.append(getData.getMax());
            buf.append(",");
            buf.append(putData.getMin());
            buf.append(",");
            buf.append(getData.getMin());
            buf.append(",");
            buf.append(stResults.getThroughputTransactionsPerSecond());
            buf.append(",");
            buf.append(stResults.getThroughputBytesPerSecond());
            buf.append(",");
            buf.append(putData.getN());
            buf.append(",");
            buf.append(getData.getN());
        } else {
            buf.append(stResults.getTestName());
            buf.append(",");
            buf.append(stResults.getTestTime());
            buf.append(",");
            buf.append(stResults.getTestType());
            buf.append(",");
            buf.append(stResults.getErrorMsg());
        }
        writer.write(buf.toString());
        writer.newLine();
    }

    protected void writeHeaderLine(BufferedWriter writer) throws IOException {
        log.debug((Object)"Write the Report Header");
        writer.write("TEST NAME, TEST DATE, TEST TYPE, NUM MEMBERS, NUM THREADS, TOTAL PUT TIME (secs), TOTAL GET TIME (secs), MEAN PUT TIME, MEAN GET TIME, MEDIAN PUT TIME, MEDIAN GET TIME, STANDARD DEVIATION PUT TIME, STANDARD DEVIATION GET TIME, MAX PUT TIME, MAX GET TIME, MIN PUT TIME, MIN GET TIME, THROUGHPUT TRANSACTIONS PER SEC, THROUGHPUT BYTES PER SEC, NUM_PUTS, NUM_GETS");
        writer.newLine();
        log.debug((Object)"Completed the Report Header");
    }
}

