#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "array.h"
#include "utils.h"

array::array(int numberofcounters)
{
	assert(numberofcounters >= 1);

	counters = NULL;
	ncounters = numberofcounters;
	strings = NULL;
	hashes = NULL;
	nin = 0;
}

array::~array()
{
	if (counters)
		free(counters);

	if (strings)
		free(strings);

	if (hashes)
		free(hashes);
}

void array::setcounter(int index, int subindex, int value)
{
	counters[(index * ncounters) + subindex] = value;
}

int array::addcounter(int index, int subindex, int value)
{
	return counters[(index * ncounters) + subindex] += value;
}

int array::getcounter(int index, int subindex)
{
	return counters[(index * ncounters) + subindex];
}

int array::addstring(char *string, int defvalue, char case_sensitive)
{
	int loop;
	int cur_hash = genhash(string, case_sensitive);

	for(loop=0; loop<nin; loop++)
	{
		if (gethash(loop) == cur_hash)
		{
			if (case_sensitive == 1 && strcmp(strings[loop], string) == 0)
			{
				(void)addcounter(loop, 0, 1);
				return loop;
			}
			else if (case_sensitive == 0 && strcasecmp(strings[loop], string) == 0)
			{
				(void)addcounter(loop, 0, 1);
				return loop;
			}
		}
	}

	int index = addelement(string, cur_hash);
	setcounter(index, 0, defvalue);

	return index;
}

int array::genhash(char *string, char case_insensitive)
{
	int len = strlen(string);
	int hash = 0;
	register int loop;

	if (case_insensitive)
	{
		for(loop=0; loop<len; loop++)
		{
			register int dummy = (hash >> 8);
			hash <<= 1;
			hash ^= dummy;
			hash ^= tolower(string[loop]);
		}
	}
	else
	{
		for(loop=0; loop<len; loop++)
		{
			register int dummy = (hash >> 8);
			hash <<= 1;
			hash ^= dummy;
			hash ^= string[loop];
		}
	}

	return hash;
}

int array::addelement(char *string, int hash)
{
	strings  = (char **   )myrealloc(strings,  sizeof(char *)   * (nin + 1), "string array");
	hashes   = (int *     )myrealloc(hashes,   sizeof(int)      * (nin + 1), "hashes array");
	counters = (long int *)myrealloc(counters, sizeof(long int) * ncounters * (nin + 1), "counter array");

	strings[nin] = strdup(string);
	hashes[nin] = hash;

	for(int loop=0; loop<ncounters; loop++)
		setcounter(nin, loop, 0);

	/* swap_entry(0, nin); */

	nin++;

	return nin-1;
}

void array::sort(int subindex)
{
	assert(subindex < ncounters);

	do_sort(subindex, 0, nin);
}

void array::do_sort(int subindex, int start, int end)
{
	for(int loop=start; loop<(end-1); loop++)
	{
		for(int loop2=loop+1; loop2<end; loop2++)
		{
			if (getcounter(loop, subindex) < getcounter(loop2, subindex))
			{
				swap_entry(loop, loop2);
			}
			else if (getcounter(loop, subindex) == getcounter(loop2, subindex) && ncounters > 1)
			{
				int dummy = (subindex + 1) % ncounters;
				if (getcounter(loop, dummy) < getcounter(loop2, dummy))
					swap_entry(loop, loop2);
			}
		}
	}
}

void array::swap_entry(int index1, int index2)
{
	char *dummy = strings[index1];
	strings[index1] = strings[index2];
	strings[index2] = dummy;

	for(int loop=0; loop<ncounters; loop++)
	{
		int dummy = getcounter(index1, loop);
		setcounter(index1, loop, getcounter(index2, loop));
		setcounter(index2, loop, dummy);
	}
}
