/* !!! WARNING WARNING WARNING WARNING WARNING WARNING WARNING !!!
 *
 * THIS FILE IS AUTOMATICALLY GENERATED BY 'generator.pl'.
 *
 * Any changes you make to this file may be overwritten.
 */

/* OCaml bindings for libvirt.
 * (C) Copyright 2007-2015 Richard W.M. Jones, Red Hat Inc.
 * https://libvirt.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version,
 * with the OCaml linking exception described in ../COPYING.LIB.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include "libvirt_c.h"

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-prototypes"
#endif

/* Automatically generated binding for virConnectClose.
 * In generator.pl this function has signature "conn : free".
 */

CAMLprim value
ocaml_libvirt_connect_close (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectClose (conn));
  CHECK_ERROR (r == -1, "virConnectClose");

  /* So that we don't double-free in the finalizer: */
  Connect_val (connv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virConnectGetHostname.
 * In generator.pl this function has signature "conn : string".
 */

CAMLprim value
ocaml_libvirt_connect_get_hostname (value connv)
{
  CAMLparam1 (connv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *r;

  NONBLOCKING (r = virConnectGetHostname (conn));
  CHECK_ERROR (!r, "virConnectGetHostname");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectGetURI.
 * In generator.pl this function has signature "conn : string".
 */

CAMLprim value
ocaml_libvirt_connect_get_uri (value connv)
{
  CAMLparam1 (connv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *r;

  NONBLOCKING (r = virConnectGetURI (conn));
  CHECK_ERROR (!r, "virConnectGetURI");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectGetType.
 * In generator.pl this function has signature "conn : static string".
 */

CAMLprim value
ocaml_libvirt_connect_get_type (value connv)
{
  CAMLparam1 (connv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *r;

  NONBLOCKING (r = virConnectGetType (conn));
  CHECK_ERROR (!r, "virConnectGetType");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDomains.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_domains (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDomains (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfDomains");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDomains.
 * In generator.pl this function has signature "conn, int : int array".
 */

CAMLprim value
ocaml_libvirt_connect_list_domains (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  int *ids, r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  ids = malloc (sizeof (*ids) * i);
  if (ids == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListDomains (conn, ids, i));
  CHECK_ERROR_CLEANUP (r == -1, free (ids), "virConnectListDomains");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i)
    Store_field (rv, i, Val_int (ids[i]));
  free (ids);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDefinedDomains.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_defined_domains (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDefinedDomains (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfDefinedDomains");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDefinedDomains.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_defined_domains (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListDefinedDomains (conn, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virConnectListDefinedDomains");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfNetworks.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_networks (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfNetworks (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfNetworks");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListNetworks.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_networks (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListNetworks (conn, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virConnectListNetworks");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDefinedNetworks.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_defined_networks (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDefinedNetworks (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfDefinedNetworks");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDefinedNetworks.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_defined_networks (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListDefinedNetworks (conn, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virConnectListDefinedNetworks");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfStoragePools.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_storage_pools (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfStoragePools (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfStoragePools");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListStoragePools.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_storage_pools (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListStoragePools (conn, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virConnectListStoragePools");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfDefinedStoragePools.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_defined_storage_pools (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfDefinedStoragePools (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfDefinedStoragePools");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListDefinedStoragePools.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_defined_storage_pools (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListDefinedStoragePools (conn, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virConnectListDefinedStoragePools");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectNumOfSecrets.
 * In generator.pl this function has signature "conn : int".
 */

CAMLprim value
ocaml_libvirt_connect_num_of_secrets (value connv)
{
  CAMLparam1 (connv);

  virConnectPtr conn = Connect_val (connv);
  int r;

  NONBLOCKING (r = virConnectNumOfSecrets (conn));
  CHECK_ERROR (r == -1, "virConnectNumOfSecrets");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virConnectListSecrets.
 * In generator.pl this function has signature "conn, int : string array".
 */

CAMLprim value
ocaml_libvirt_connect_list_secrets (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal2 (rv, strv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virConnectListSecrets (conn, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virConnectListSecrets");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectGetCapabilities.
 * In generator.pl this function has signature "conn : string".
 */

CAMLprim value
ocaml_libvirt_connect_get_capabilities (value connv)
{
  CAMLparam1 (connv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  char *r;

  NONBLOCKING (r = virConnectGetCapabilities (conn));
  CHECK_ERROR (!r, "virConnectGetCapabilities");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virConnectDomainEventDeregisterAny.
 * In generator.pl this function has signature "conn, int : unit".
 */

CAMLprim value
ocaml_libvirt_connect_domain_event_deregister_any (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virConnectDomainEventDeregisterAny (conn, i));
  CHECK_ERROR (r == -1, "virConnectDomainEventDeregisterAny");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainCreateLinux.
 * In generator.pl this function has signature "conn, string, 0U : dom".
 */

CAMLprim value
ocaml_libvirt_domain_create_linux (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainCreateLinux (conn, str, 0));
  CHECK_ERROR (!r, "virDomainCreateLinux");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainCreateXML.
 * In generator.pl this function has signature "conn, string, unsigned : dom".
 */

CAMLprim value
ocaml_libvirt_domain_create_xml (value connv, value strv, value uv)
{
  CAMLparam3 (connv, strv, uv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  unsigned int u = Int_val (uv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainCreateXML (conn, str, u));
  CHECK_ERROR (!r, "virDomainCreateXML");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainFree.
 * In generator.pl this function has signature "dom : free".
 */

CAMLprim value
ocaml_libvirt_domain_free (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainFree (dom));
  CHECK_ERROR (r == -1, "virDomainFree");

  /* So that we don't double-free in the finalizer: */
  Domain_val (domv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDestroy.
 * In generator.pl this function has signature "dom : free".
 */

CAMLprim value
ocaml_libvirt_domain_destroy (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainDestroy (dom));
  CHECK_ERROR (r == -1, "virDomainDestroy");

  /* So that we don't double-free in the finalizer: */
  Domain_val (domv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainLookupByName.
 * In generator.pl this function has signature "conn, string : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_name (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByName (conn, str));
  CHECK_ERROR (!r, "virDomainLookupByName");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainLookupByID.
 * In generator.pl this function has signature "conn, int : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_id (value connv, value iv)
{
  CAMLparam2 (connv, iv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  int i = Int_val (iv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByID (conn, i));
  CHECK_ERROR (!r, "virDomainLookupByID");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, "virDomainLookupByUUID");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : dom".
 */

CAMLprim value
ocaml_libvirt_domain_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, "virDomainLookupByUUIDString");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetName.
 * In generator.pl this function has signature "dom : static string".
 */

CAMLprim value
ocaml_libvirt_domain_get_name (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  const char *r;

  NONBLOCKING (r = virDomainGetName (dom));
  CHECK_ERROR (!r, "virDomainGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetOSType.
 * In generator.pl this function has signature "dom : string".
 */

CAMLprim value
ocaml_libvirt_domain_get_os_type (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  char *r;

  NONBLOCKING (r = virDomainGetOSType (dom));
  CHECK_ERROR (!r, "virDomainGetOSType");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetXMLDesc.
 * In generator.pl this function has signature "dom, 0 : string".
 */

CAMLprim value
ocaml_libvirt_domain_get_xml_desc (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  char *r;

  NONBLOCKING (r = virDomainGetXMLDesc (dom, 0));
  CHECK_ERROR (!r, "virDomainGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetUUID.
 * In generator.pl this function has signature "dom : uuid".
 */

CAMLprim value
ocaml_libvirt_domain_get_uuid (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virDomainGetUUID (dom, uuid));
  CHECK_ERROR (r == -1, "virDomainGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (Bytes_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetUUIDString.
 * In generator.pl this function has signature "dom : uuid string".
 */

CAMLprim value
ocaml_libvirt_domain_get_uuid_string (value domv)
{
  CAMLparam1 (domv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virDomainGetUUIDString (dom, uuid));
  CHECK_ERROR (r == -1, "virDomainGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainGetMaxVcpus.
 * In generator.pl this function has signature "dom : int".
 */

CAMLprim value
ocaml_libvirt_domain_get_max_vcpus (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainGetMaxVcpus (dom));
  CHECK_ERROR (r == -1, "virDomainGetMaxVcpus");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virDomainSave.
 * In generator.pl this function has signature "dom, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_save (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  virDomainPtr dom = Domain_val (domv);
  const char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainSave (dom, str));
  CHECK_ERROR (r == -1, "virDomainSave");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainRestore.
 * In generator.pl this function has signature "conn, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_restore (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainRestore (conn, str));
  CHECK_ERROR (r == -1, "virDomainRestore");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainCoreDump.
 * In generator.pl this function has signature "dom, string, 0 : unit".
 */

CAMLprim value
ocaml_libvirt_domain_core_dump (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  CAMLlocal1 (rv);
  virDomainPtr dom = Domain_val (domv);
  const char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainCoreDump (dom, str, 0));
  CHECK_ERROR (!r, "virDomainCoreDump");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainSuspend.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_suspend (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainSuspend (dom));
  CHECK_ERROR (r == -1, "virDomainSuspend");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainResume.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_resume (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainResume (dom));
  CHECK_ERROR (r == -1, "virDomainResume");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainShutdown.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_shutdown (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainShutdown (dom));
  CHECK_ERROR (r == -1, "virDomainShutdown");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainReboot.
 * In generator.pl this function has signature "dom, 0 : unit".
 */

CAMLprim value
ocaml_libvirt_domain_reboot (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainReboot (dom, 0));
  CHECK_ERROR (r == -1, "virDomainReboot");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDefineXML.
 * In generator.pl this function has signature "conn, string : dom".
 */

CAMLprim value
ocaml_libvirt_domain_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virDomainPtr r;

  NONBLOCKING (r = virDomainDefineXML (conn, str));
  CHECK_ERROR (!r, "virDomainDefineXML");

  rv = Val_domain (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virDomainUndefine.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_undefine (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainUndefine (dom));
  CHECK_ERROR (r == -1, "virDomainUndefine");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainCreate.
 * In generator.pl this function has signature "dom : unit".
 */

CAMLprim value
ocaml_libvirt_domain_create (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r;

  NONBLOCKING (r = virDomainCreate (dom));
  CHECK_ERROR (r == -1, "virDomainCreate");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainAttachDevice.
 * In generator.pl this function has signature "dom, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_attach_device (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  virDomainPtr dom = Domain_val (domv);
  const char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainAttachDevice (dom, str));
  CHECK_ERROR (r == -1, "virDomainAttachDevice");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDetachDevice.
 * In generator.pl this function has signature "dom, string : unit".
 */

CAMLprim value
ocaml_libvirt_domain_detach_device (value domv, value strv)
{
  CAMLparam2 (domv, strv);

  virDomainPtr dom = Domain_val (domv);
  const char *str = String_val (strv);
  int r;

  NONBLOCKING (r = virDomainDetachDevice (dom, str));
  CHECK_ERROR (r == -1, "virDomainDetachDevice");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainDetachDeviceFlags.
 * In generator.pl this function has signature "dom, string, unsigned : unit".
 */

CAMLprim value
ocaml_libvirt_domain_detach_device_flags (value domv, value strv, value uv)
{
  CAMLparam3 (domv, strv, uv);

  virDomainPtr dom = Domain_val (domv);
  const char *str = String_val (strv);
  unsigned int u = Int_val (uv);
  int r;

  NONBLOCKING (r = virDomainDetachDeviceFlags (dom, str, u));
  CHECK_ERROR (r == -1, "virDomainDetachDeviceFlags");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virDomainGetAutostart.
 * In generator.pl this function has signature "dom : bool".
 */

CAMLprim value
ocaml_libvirt_domain_get_autostart (value domv)
{
  CAMLparam1 (domv);

  virDomainPtr dom = Domain_val (domv);
  int r, b;

  NONBLOCKING (r = virDomainGetAutostart (dom, &b));
  CHECK_ERROR (r == -1, "virDomainGetAutostart");

  CAMLreturn (b ? Val_true : Val_false);
}

/* Automatically generated binding for virDomainSetAutostart.
 * In generator.pl this function has signature "dom, bool : unit".
 */

CAMLprim value
ocaml_libvirt_domain_set_autostart (value domv, value bv)
{
  CAMLparam2 (domv, bv);

  virDomainPtr dom = Domain_val (domv);
  int r, b;

  b = bv == Val_true ? 1 : 0;

  NONBLOCKING (r = virDomainSetAutostart (dom, b));
  CHECK_ERROR (r == -1, "virDomainSetAutostart");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkFree.
 * In generator.pl this function has signature "net : free".
 */

CAMLprim value
ocaml_libvirt_network_free (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  int r;

  NONBLOCKING (r = virNetworkFree (net));
  CHECK_ERROR (r == -1, "virNetworkFree");

  /* So that we don't double-free in the finalizer: */
  Network_val (netv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkDestroy.
 * In generator.pl this function has signature "net : free".
 */

CAMLprim value
ocaml_libvirt_network_destroy (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  int r;

  NONBLOCKING (r = virNetworkDestroy (net));
  CHECK_ERROR (r == -1, "virNetworkDestroy");

  /* So that we don't double-free in the finalizer: */
  Network_val (netv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkLookupByName.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_lookup_by_name (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkLookupByName (conn, str));
  CHECK_ERROR (!r, "virNetworkLookupByName");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : net".
 */

CAMLprim value
ocaml_libvirt_network_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, "virNetworkLookupByUUID");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, "virNetworkLookupByUUIDString");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetName.
 * In generator.pl this function has signature "net : static string".
 */

CAMLprim value
ocaml_libvirt_network_get_name (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  const char *r;

  NONBLOCKING (r = virNetworkGetName (net));
  CHECK_ERROR (!r, "virNetworkGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetXMLDesc.
 * In generator.pl this function has signature "net, 0 : string".
 */

CAMLprim value
ocaml_libvirt_network_get_xml_desc (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  char *r;

  NONBLOCKING (r = virNetworkGetXMLDesc (net, 0));
  CHECK_ERROR (!r, "virNetworkGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetBridgeName.
 * In generator.pl this function has signature "net : string".
 */

CAMLprim value
ocaml_libvirt_network_get_bridge_name (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  char *r;

  NONBLOCKING (r = virNetworkGetBridgeName (net));
  CHECK_ERROR (!r, "virNetworkGetBridgeName");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetUUID.
 * In generator.pl this function has signature "net : uuid".
 */

CAMLprim value
ocaml_libvirt_network_get_uuid (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virNetworkGetUUID (net, uuid));
  CHECK_ERROR (r == -1, "virNetworkGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (Bytes_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkGetUUIDString.
 * In generator.pl this function has signature "net : uuid string".
 */

CAMLprim value
ocaml_libvirt_network_get_uuid_string (value netv)
{
  CAMLparam1 (netv);

  CAMLlocal1 (rv);
  virNetworkPtr net = Network_val (netv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virNetworkGetUUIDString (net, uuid));
  CHECK_ERROR (r == -1, "virNetworkGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkUndefine.
 * In generator.pl this function has signature "net : unit".
 */

CAMLprim value
ocaml_libvirt_network_undefine (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  int r;

  NONBLOCKING (r = virNetworkUndefine (net));
  CHECK_ERROR (r == -1, "virNetworkUndefine");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkCreateXML.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_create_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkCreateXML (conn, str));
  CHECK_ERROR (!r, "virNetworkCreateXML");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkDefineXML.
 * In generator.pl this function has signature "conn, string : net".
 */

CAMLprim value
ocaml_libvirt_network_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virNetworkPtr r;

  NONBLOCKING (r = virNetworkDefineXML (conn, str));
  CHECK_ERROR (!r, "virNetworkDefineXML");

  rv = Val_network (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virNetworkCreate.
 * In generator.pl this function has signature "net : unit".
 */

CAMLprim value
ocaml_libvirt_network_create (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  int r;

  NONBLOCKING (r = virNetworkCreate (net));
  CHECK_ERROR (r == -1, "virNetworkCreate");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virNetworkGetAutostart.
 * In generator.pl this function has signature "net : bool".
 */

CAMLprim value
ocaml_libvirt_network_get_autostart (value netv)
{
  CAMLparam1 (netv);

  virNetworkPtr net = Network_val (netv);
  int r, b;

  NONBLOCKING (r = virNetworkGetAutostart (net, &b));
  CHECK_ERROR (r == -1, "virNetworkGetAutostart");

  CAMLreturn (b ? Val_true : Val_false);
}

/* Automatically generated binding for virNetworkSetAutostart.
 * In generator.pl this function has signature "net, bool : unit".
 */

CAMLprim value
ocaml_libvirt_network_set_autostart (value netv, value bv)
{
  CAMLparam2 (netv, bv);

  virNetworkPtr net = Network_val (netv);
  int r, b;

  b = bv == Val_true ? 1 : 0;

  NONBLOCKING (r = virNetworkSetAutostart (net, b));
  CHECK_ERROR (r == -1, "virNetworkSetAutostart");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolFree.
 * In generator.pl this function has signature "pool : free".
 */

CAMLprim value
ocaml_libvirt_storage_pool_free (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolFree (pool));
  CHECK_ERROR (r == -1, "virStoragePoolFree");

  /* So that we don't double-free in the finalizer: */
  Pool_val (poolv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolDestroy.
 * In generator.pl this function has signature "pool : free".
 */

CAMLprim value
ocaml_libvirt_storage_pool_destroy (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolDestroy (pool));
  CHECK_ERROR (r == -1, "virStoragePoolDestroy");

  /* So that we don't double-free in the finalizer: */
  Pool_val (poolv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolLookupByName.
 * In generator.pl this function has signature "conn, string : pool".
 */

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_name (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByName (conn, str));
  CHECK_ERROR (!r, "virStoragePoolLookupByName");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : pool".
 */

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, "virStoragePoolLookupByUUID");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : pool".
 */

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, "virStoragePoolLookupByUUIDString");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolGetName.
 * In generator.pl this function has signature "pool : static string".
 */

CAMLprim value
ocaml_libvirt_storage_pool_get_name (value poolv)
{
  CAMLparam1 (poolv);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  const char *r;

  NONBLOCKING (r = virStoragePoolGetName (pool));
  CHECK_ERROR (!r, "virStoragePoolGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolGetXMLDesc.
 * In generator.pl this function has signature "pool, 0U : string".
 */

CAMLprim value
ocaml_libvirt_storage_pool_get_xml_desc (value poolv)
{
  CAMLparam1 (poolv);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  char *r;

  NONBLOCKING (r = virStoragePoolGetXMLDesc (pool, 0));
  CHECK_ERROR (!r, "virStoragePoolGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolGetUUID.
 * In generator.pl this function has signature "pool : uuid".
 */

CAMLprim value
ocaml_libvirt_storage_pool_get_uuid (value poolv)
{
  CAMLparam1 (poolv);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virStoragePoolGetUUID (pool, uuid));
  CHECK_ERROR (r == -1, "virStoragePoolGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (Bytes_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolGetUUIDString.
 * In generator.pl this function has signature "pool : uuid string".
 */

CAMLprim value
ocaml_libvirt_storage_pool_get_uuid_string (value poolv)
{
  CAMLparam1 (poolv);

  CAMLlocal1 (rv);
  virStoragePoolPtr pool = Pool_val (poolv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virStoragePoolGetUUIDString (pool, uuid));
  CHECK_ERROR (r == -1, "virStoragePoolGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolCreateXML.
 * In generator.pl this function has signature "conn, string, 0U : pool".
 */

CAMLprim value
ocaml_libvirt_storage_pool_create_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolCreateXML (conn, str, 0));
  CHECK_ERROR (!r, "virStoragePoolCreateXML");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolDefineXML.
 * In generator.pl this function has signature "conn, string, 0U : pool".
 */

CAMLprim value
ocaml_libvirt_storage_pool_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolDefineXML (conn, str, 0));
  CHECK_ERROR (!r, "virStoragePoolDefineXML");

  rv = Val_pool (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolBuild.
 * In generator.pl this function has signature "pool, uint : unit".
 */

CAMLprim value
ocaml_libvirt_storage_pool_build (value poolv, value iv)
{
  CAMLparam2 (poolv, iv);

  virStoragePoolPtr pool = Pool_val (poolv);
  unsigned int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virStoragePoolBuild (pool, i));
  CHECK_ERROR (r == -1, "virStoragePoolBuild");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolUndefine.
 * In generator.pl this function has signature "pool : unit".
 */

CAMLprim value
ocaml_libvirt_storage_pool_undefine (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolUndefine (pool));
  CHECK_ERROR (r == -1, "virStoragePoolUndefine");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolCreate.
 * In generator.pl this function has signature "pool, 0U : unit".
 */

CAMLprim value
ocaml_libvirt_storage_pool_create (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolCreate (pool, 0));
  CHECK_ERROR (r == -1, "virStoragePoolCreate");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolDelete.
 * In generator.pl this function has signature "pool, uint : unit".
 */

CAMLprim value
ocaml_libvirt_storage_pool_delete (value poolv, value iv)
{
  CAMLparam2 (poolv, iv);

  virStoragePoolPtr pool = Pool_val (poolv);
  unsigned int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virStoragePoolDelete (pool, i));
  CHECK_ERROR (r == -1, "virStoragePoolDelete");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolRefresh.
 * In generator.pl this function has signature "pool, 0U : unit".
 */

CAMLprim value
ocaml_libvirt_storage_pool_refresh (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolRefresh (pool, 0));
  CHECK_ERROR (r == -1, "virStoragePoolRefresh");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolGetAutostart.
 * In generator.pl this function has signature "pool : bool".
 */

CAMLprim value
ocaml_libvirt_storage_pool_get_autostart (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r, b;

  NONBLOCKING (r = virStoragePoolGetAutostart (pool, &b));
  CHECK_ERROR (r == -1, "virStoragePoolGetAutostart");

  CAMLreturn (b ? Val_true : Val_false);
}

/* Automatically generated binding for virStoragePoolSetAutostart.
 * In generator.pl this function has signature "pool, bool : unit".
 */

CAMLprim value
ocaml_libvirt_storage_pool_set_autostart (value poolv, value bv)
{
  CAMLparam2 (poolv, bv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r, b;

  b = bv == Val_true ? 1 : 0;

  NONBLOCKING (r = virStoragePoolSetAutostart (pool, b));
  CHECK_ERROR (r == -1, "virStoragePoolSetAutostart");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStoragePoolNumOfVolumes.
 * In generator.pl this function has signature "pool : int".
 */

CAMLprim value
ocaml_libvirt_storage_pool_num_of_volumes (value poolv)
{
  CAMLparam1 (poolv);

  virStoragePoolPtr pool = Pool_val (poolv);
  int r;

  NONBLOCKING (r = virStoragePoolNumOfVolumes (pool));
  CHECK_ERROR (r == -1, "virStoragePoolNumOfVolumes");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virStoragePoolListVolumes.
 * In generator.pl this function has signature "pool, int : string array".
 */

CAMLprim value
ocaml_libvirt_storage_pool_list_volumes (value poolv, value iv)
{
  CAMLparam2 (poolv, iv);

  CAMLlocal2 (rv, strv);
  virStoragePoolPtr pool = Pool_val (poolv);
  int i = Int_val (iv);
  char **names;
  int r;

  /* Some libvirt List* functions still throw exceptions if i == 0,
   * so catch that and return an empty array directly.  This changes
   * the semantics slightly (masking other failures) but it's
   * unlikely anyone will care.  RWMJ 2008/06/10
   */
  if (i == 0) {
    rv = caml_alloc (0, 0);
    CAMLreturn (rv);
  }

  names = malloc (sizeof (*names) * i);
  if (names == NULL)
    caml_raise_out_of_memory ();

  NONBLOCKING (r = virStoragePoolListVolumes (pool, names, i));
  CHECK_ERROR_CLEANUP (r == -1, free (names), "virStoragePoolListVolumes");

  rv = caml_alloc (r, 0);
  for (i = 0; i < r; ++i) {
    strv = caml_copy_string (names[i]);
    Store_field (rv, i, strv);
    free (names[i]);
  }
  free (names);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolFree.
 * In generator.pl this function has signature "vol : free".
 */

CAMLprim value
ocaml_libvirt_storage_vol_free (value volv)
{
  CAMLparam1 (volv);

  virStorageVolPtr vol = Volume_val (volv);
  int r;

  NONBLOCKING (r = virStorageVolFree (vol));
  CHECK_ERROR (r == -1, "virStorageVolFree");

  /* So that we don't double-free in the finalizer: */
  Volume_val (volv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStorageVolDelete.
 * In generator.pl this function has signature "vol, uint : unit".
 */

CAMLprim value
ocaml_libvirt_storage_vol_delete (value volv, value iv)
{
  CAMLparam2 (volv, iv);

  virStorageVolPtr vol = Volume_val (volv);
  unsigned int i = Int_val (iv);
  int r;

  NONBLOCKING (r = virStorageVolDelete (vol, i));
  CHECK_ERROR (r == -1, "virStorageVolDelete");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virStorageVolLookupByName.
 * In generator.pl this function has signature "pool, string : vol from pool".
 */

CAMLprim value
ocaml_libvirt_storage_vol_lookup_by_name (value poolv, value strv)
{
  CAMLparam2 (poolv, strv);

  CAMLlocal2 (rv, connv);
  virStoragePoolPtr pool = Pool_val (poolv);
  const char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolLookupByName (pool, str));
  CHECK_ERROR (!r, "virStorageVolLookupByName");

  connv = Field (poolv, 1);
  rv = Val_volume (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolLookupByKey.
 * In generator.pl this function has signature "conn, string : vol".
 */

CAMLprim value
ocaml_libvirt_storage_vol_lookup_by_key (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolLookupByKey (conn, str));
  CHECK_ERROR (!r, "virStorageVolLookupByKey");

  rv = Val_volume (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolLookupByPath.
 * In generator.pl this function has signature "conn, string : vol".
 */

CAMLprim value
ocaml_libvirt_storage_vol_lookup_by_path (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolLookupByPath (conn, str));
  CHECK_ERROR (!r, "virStorageVolLookupByPath");

  rv = Val_volume (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolCreateXML.
 * In generator.pl this function has signature "pool, string, 0U : vol from pool".
 */

CAMLprim value
ocaml_libvirt_storage_vol_create_xml (value poolv, value strv)
{
  CAMLparam2 (poolv, strv);

  CAMLlocal2 (rv, connv);
  virStoragePoolPtr pool = Pool_val (poolv);
  const char *str = String_val (strv);
  virStorageVolPtr r;

  NONBLOCKING (r = virStorageVolCreateXML (pool, str, 0));
  CHECK_ERROR (!r, "virStorageVolCreateXML");

  connv = Field (poolv, 1);
  rv = Val_volume (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolGetXMLDesc.
 * In generator.pl this function has signature "vol, 0U : string".
 */

CAMLprim value
ocaml_libvirt_storage_vol_get_xml_desc (value volv)
{
  CAMLparam1 (volv);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  char *r;

  NONBLOCKING (r = virStorageVolGetXMLDesc (vol, 0));
  CHECK_ERROR (!r, "virStorageVolGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolGetPath.
 * In generator.pl this function has signature "vol : string".
 */

CAMLprim value
ocaml_libvirt_storage_vol_get_path (value volv)
{
  CAMLparam1 (volv);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  char *r;

  NONBLOCKING (r = virStorageVolGetPath (vol));
  CHECK_ERROR (!r, "virStorageVolGetPath");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolGetKey.
 * In generator.pl this function has signature "vol : static string".
 */

CAMLprim value
ocaml_libvirt_storage_vol_get_key (value volv)
{
  CAMLparam1 (volv);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  const char *r;

  NONBLOCKING (r = virStorageVolGetKey (vol));
  CHECK_ERROR (!r, "virStorageVolGetKey");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStorageVolGetName.
 * In generator.pl this function has signature "vol : static string".
 */

CAMLprim value
ocaml_libvirt_storage_vol_get_name (value volv)
{
  CAMLparam1 (volv);

  CAMLlocal1 (rv);
  virStorageVolPtr vol = Volume_val (volv);
  const char *r;

  NONBLOCKING (r = virStorageVolGetName (vol));
  CHECK_ERROR (!r, "virStorageVolGetName");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virStoragePoolLookupByVolume.
 * In generator.pl this function has signature "vol : pool from vol".
 */

CAMLprim value
ocaml_libvirt_storage_pool_lookup_by_volume (value volv)
{
  CAMLparam1 (volv);

  CAMLlocal2 (rv, connv);
  virStorageVolPtr vol = Volume_val (volv);
  virStoragePoolPtr r;

  NONBLOCKING (r = virStoragePoolLookupByVolume (vol));
  CHECK_ERROR (!r, "virStoragePoolLookupByVolume");

  connv = Field (volv, 1);
  rv = Val_pool (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretFree.
 * In generator.pl this function has signature "sec : free".
 */

CAMLprim value
ocaml_libvirt_secret_free (value secv)
{
  CAMLparam1 (secv);

  virSecretPtr sec = Secret_val (secv);
  int r;

  NONBLOCKING (r = virSecretFree (sec));
  CHECK_ERROR (r == -1, "virSecretFree");

  /* So that we don't double-free in the finalizer: */
  Secret_val (secv) = NULL;

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virSecretUndefine.
 * In generator.pl this function has signature "sec : unit".
 */

CAMLprim value
ocaml_libvirt_secret_undefine (value secv)
{
  CAMLparam1 (secv);

  virSecretPtr sec = Secret_val (secv);
  int r;

  NONBLOCKING (r = virSecretUndefine (sec));
  CHECK_ERROR (r == -1, "virSecretUndefine");

  CAMLreturn (Val_unit);
}

/* Automatically generated binding for virSecretLookupByUUID.
 * In generator.pl this function has signature "conn, uuid : sec".
 */

CAMLprim value
ocaml_libvirt_secret_lookup_by_uuid (value connv, value uuidv)
{
  CAMLparam2 (connv, uuidv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  unsigned char *uuid = (unsigned char *) String_val (uuidv);
  virSecretPtr r;

  NONBLOCKING (r = virSecretLookupByUUID (conn, uuid));
  CHECK_ERROR (!r, "virSecretLookupByUUID");

  rv = Val_secret (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretLookupByUUIDString.
 * In generator.pl this function has signature "conn, string : sec".
 */

CAMLprim value
ocaml_libvirt_secret_lookup_by_uuid_string (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virSecretPtr r;

  NONBLOCKING (r = virSecretLookupByUUIDString (conn, str));
  CHECK_ERROR (!r, "virSecretLookupByUUIDString");

  rv = Val_secret (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretDefineXML.
 * In generator.pl this function has signature "conn, string, 0 : sec".
 */

CAMLprim value
ocaml_libvirt_secret_define_xml (value connv, value strv)
{
  CAMLparam2 (connv, strv);

  CAMLlocal1 (rv);
  virConnectPtr conn = Connect_val (connv);
  const char *str = String_val (strv);
  virSecretPtr r;

  NONBLOCKING (r = virSecretDefineXML (conn, str, 0));
  CHECK_ERROR (!r, "virSecretDefineXML");

  rv = Val_secret (r, connv);

  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretGetUUID.
 * In generator.pl this function has signature "sec : uuid".
 */

CAMLprim value
ocaml_libvirt_secret_get_uuid (value secv)
{
  CAMLparam1 (secv);

  CAMLlocal1 (rv);
  virSecretPtr sec = Secret_val (secv);
  unsigned char uuid[VIR_UUID_BUFLEN];
  int r;

  NONBLOCKING (r = virSecretGetUUID (sec, uuid));
  CHECK_ERROR (r == -1, "virSecretGetUUID");

  /* UUIDs are byte arrays with a fixed length. */
  rv = caml_alloc_string (VIR_UUID_BUFLEN);
  memcpy (Bytes_val (rv), uuid, VIR_UUID_BUFLEN);
  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretGetUUIDString.
 * In generator.pl this function has signature "sec : uuid string".
 */

CAMLprim value
ocaml_libvirt_secret_get_uuid_string (value secv)
{
  CAMLparam1 (secv);

  CAMLlocal1 (rv);
  virSecretPtr sec = Secret_val (secv);
  char uuid[VIR_UUID_STRING_BUFLEN];
  int r;

  NONBLOCKING (r = virSecretGetUUIDString (sec, uuid));
  CHECK_ERROR (r == -1, "virSecretGetUUIDString");

  rv = caml_copy_string (uuid);
  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretGetUsageType.
 * In generator.pl this function has signature "sec : int".
 */

CAMLprim value
ocaml_libvirt_secret_get_usage_type (value secv)
{
  CAMLparam1 (secv);

  virSecretPtr sec = Secret_val (secv);
  int r;

  NONBLOCKING (r = virSecretGetUsageType (sec));
  CHECK_ERROR (r == -1, "virSecretGetUsageType");

  CAMLreturn (Val_int (r));
}

/* Automatically generated binding for virSecretGetUsageID.
 * In generator.pl this function has signature "sec : static string".
 */

CAMLprim value
ocaml_libvirt_secret_get_usage_id (value secv)
{
  CAMLparam1 (secv);

  CAMLlocal1 (rv);
  virSecretPtr sec = Secret_val (secv);
  const char *r;

  NONBLOCKING (r = virSecretGetUsageID (sec));
  CHECK_ERROR (!r, "virSecretGetUsageID");

  rv = caml_copy_string (r);
  CAMLreturn (rv);
}

/* Automatically generated binding for virSecretGetXMLDesc.
 * In generator.pl this function has signature "sec, 0 : string".
 */

CAMLprim value
ocaml_libvirt_secret_get_xml_desc (value secv)
{
  CAMLparam1 (secv);

  CAMLlocal1 (rv);
  virSecretPtr sec = Secret_val (secv);
  char *r;

  NONBLOCKING (r = virSecretGetXMLDesc (sec, 0));
  CHECK_ERROR (!r, "virSecretGetXMLDesc");

  rv = caml_copy_string (r);
  free (r);
  CAMLreturn (rv);
}

/* EOF */
