/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.synthetic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.endpoints.DefaultEndpointsModule;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsChangeTracker;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.oas.OasArrayValue;
import com.intellij.microservices.oas.OasBooleanValue;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasExample;
import com.intellij.microservices.oas.OasExampleValue;
import com.intellij.microservices.oas.OasExportUtilsKt;
import com.intellij.microservices.oas.OasHeader;
import com.intellij.microservices.oas.OasMediaTypeObject;
import com.intellij.microservices.oas.OasNullValue;
import com.intellij.microservices.oas.OasNumberValue;
import com.intellij.microservices.oas.OasObjectValue;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasProperty;
import com.intellij.microservices.oas.OasRequestBody;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.microservices.oas.OasStringValue;
import com.intellij.microservices.oas.OasTag;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.swagger.core.synthetic.ExportOpenApiRootTypeKt;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00be\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0007\u001a\u001a\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\rH\u0007\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a.\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u001a\u0016\u0010\u0019\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b\u001a.\u0010\u0019\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00160\u0015H\u0002\u001aF\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d\"\b\b\u0000\u0010\u001e*\u00020\u001f\"\b\b\u0001\u0010 *\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u0002H 0\u0016H\u0002\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a \u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u001a\"\u0010(\u001a\u0004\u0018\u00010\u00012\u0006\u0010)\u001a\u00020\u00032\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0007\u001a\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a2\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u00100\u001a\u000201H\u0007\u001a\u0016\u00102\u001a\u00020\t2\u0006\u0010,\u001a\u00020+2\u0006\u00103\u001a\u000204\u001a\u0018\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020+2\u0006\u00107\u001a\u000208H\u0002\u001a\u001e\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020+2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u0015H\u0002\u001a\u001e\u0010=\u001a\u00020\t2\u0006\u0010:\u001a\u00020+2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a$\u0010>\u001a\u00020\t2\u0006\u0010:\u001a\u00020+2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020A0@H\u0002\u001a \u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0001H\u0002\u001a\u0018\u0010G\u001a\u00020\t2\u0006\u0010H\u001a\u00020I2\u0006\u0010D\u001a\u00020EH\u0002\u001a\u0018\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020+2\u0006\u0010L\u001a\u00020MH\u0002\u001a\u0018\u0010N\u001a\u00020\t2\u0006\u0010:\u001a\u00020+2\u0006\u0010O\u001a\u00020PH\u0002\u001a\u0018\u0010Q\u001a\u00020\t2\u0006\u0010R\u001a\u00020+2\u0006\u0010O\u001a\u00020PH\u0002\u001a\u0018\u0010S\u001a\u00020\t2\u0006\u0010:\u001a\u00020+2\u0006\u0010O\u001a\u00020PH\u0002\u00a8\u0006T"}, d2={"generateOasPreview", "", "openApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "generateOasDraftAliased", "projectName", "models", "generateOasDraft", "exportOasDraft", "", "project", "Lcom/intellij/openapi/project/Project;", "modelProvider", "Lkotlin/Function0;", "generateOasDraftFile", "Lcom/intellij/psi/PsiFile;", "json", "generateOasExports", "module", "Lcom/intellij/openapi/module/Module;", "providers", "", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "writer", "Ljava/io/Writer;", "getModuleSpecification", "moduleEntity", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "getEndpointSpecifications", "", "G", "", "E", "provider", "createFilter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "generateOasSpecificationFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "specification", "prefixes", "generateOasJsonSchemaForRequestBody", "oasSpecification", "createNestedNodeWithSchemaPrefixes", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "rootNode", "generateOasContent", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "prettyPrint", "", "appendPathToJson", "model", "Lcom/intellij/microservices/oas/OasEndpointPath;", "appendOperationToJson", "pathNode", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "appendTags", "parentNode", "tags", "Lcom/intellij/microservices/oas/OasTag;", "appendOperationTags", "appendExamplesToJson", "examples", "", "Lcom/intellij/microservices/oas/OasExample;", "appendExampleValueToJson", "exampleObject", "exampleValue", "Lcom/intellij/microservices/oas/OasExampleValue;", "fieldName", "appendItemToArray", "arrayNode", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "appendComponentsToJson", "componentsNode", "oasComponents", "Lcom/intellij/microservices/oas/OasComponents;", "appendSchema", "schema", "Lcom/intellij/microservices/oas/OasSchema;", "appendSchemaTypeAndFormat", "schemaNode", "appendEnum", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nOasSerializationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OasSerializationUtils.kt\ncom/intellij/swagger/core/synthetic/OasSerializationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 EndpointsChangeTracker.kt\ncom/intellij/microservices/endpoints/EndpointsChangeTracker$Companion\n*L\n1#1,543:1\n1872#2,3:544\n774#2:547\n865#2,2:548\n1368#2:550\n1454#2,5:551\n1368#2:557\n1454#2,2:558\n1611#2,9:560\n1863#2:569\n1864#2:571\n1620#2:572\n1456#2,3:573\n1797#2,3:576\n1863#2:579\n1863#2,2:580\n1864#2:582\n1863#2,2:583\n1863#2,2:585\n1863#2,2:587\n1863#2,2:589\n1863#2,2:595\n1863#2,2:599\n1863#2,2:601\n1863#2,2:603\n1#3:556\n1#3:570\n216#4,2:591\n216#4,2:593\n216#4,2:597\n25#5,8:605\n*S KotlinDebug\n*F\n+ 1 OasSerializationUtils.kt\ncom/intellij/swagger/core/synthetic/OasSerializationUtilsKt\n*L\n49#1:544,3\n146#1:547\n146#1:548,2\n147#1:550\n147#1:551,5\n155#1:557\n155#1:558,2\n156#1:560,9\n156#1:569\n156#1:571\n156#1:572\n155#1:573,3\n219#1:576,3\n332#1:579\n350#1:580,2\n332#1:582\n370#1:583,2\n383#1:585,2\n395#1:587,2\n406#1:589,2\n442#1:595,2\n469#1:599,2\n494#1:601,2\n541#1:603,2\n156#1:570\n410#1:591,2\n436#1:593,2\n463#1:597,2\n102#1:605,8\n*E\n"})
public final class OasSerializationUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public static final String generateOasPreview(@NotNull OpenApiSpecification openApiSpecification) {
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        StringWriter writer = new StringWriter();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        Iterable $this$forEachIndexed$iv = openApiSpecification.getPaths();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void model;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OasEndpointPath oasEndpointPath = (OasEndpointPath)item$iv;
            int index = n;
            boolean bl = false;
            if (index != 0) {
                writer.getBuffer().append("\n---\n");
            }
            YAMLGenerator generator = factory.createGenerator((Writer)writer);
            ObjectNode root = mapper.createObjectNode();
            Intrinsics.checkNotNull((Object)root);
            OasSerializationUtilsKt.appendPathToJson(root, (OasEndpointPath)model);
            mapper.writeTree((JsonGenerator)generator, (JsonNode)root);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String document = string;
        StringBuilder paddingBuilder = new StringBuilder();
        String[] stringArray = new String[]{"\n"};
        for (String s : StringsKt.split$default((CharSequence)document, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            StringBuilder stringBuilder = Intrinsics.areEqual((Object)s, (Object)"---") ? paddingBuilder.append(s) : paddingBuilder.append("  ").append(s);
            paddingBuilder.append("\n");
        }
        String string2 = paddingBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
    }

    private static final String generateOasDraftAliased(String projectName, OpenApiSpecification models) {
        return OasSerializationUtilsKt.generateOasDraft(projectName, models);
    }

    @NlsSafe
    @NotNull
    public static final String generateOasDraft(@NotNull String projectName, @NotNull OpenApiSpecification models) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)models, (String)"models");
        YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        Writer writer = new StringWriter();
        Intrinsics.checkNotNull((Object)factory);
        OasSerializationUtilsKt.generateOasContent((JsonFactory)factory, projectName, models, writer, false);
        return writer.toString();
    }

    @ApiStatus.Internal
    public static final void exportOasDraft(@Nullable OpenApiSpecification models, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        OasSerializationUtilsKt.exportOasDraft(project, (Function0<OpenApiSpecification>)((Function0)() -> OasSerializationUtilsKt.exportOasDraft$lambda$1(models)));
    }

    @ApiStatus.Internal
    public static final void exportOasDraft(@NotNull Project project, @NotNull Function0<OpenApiSpecification> modelProvider) {
        FileEditorManager fileEditorManager;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modelProvider, (String)"modelProvider");
        Ref fileRef = new Ref(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> OasSerializationUtilsKt.exportOasDraft$lambda$5(project, modelProvider, fileRef), MicroservicesBundle.message((String)"progress.export.openapi.draft", (Object[])new Object[0]), true, project);
        PsiFile generatedFile = (PsiFile)fileRef.get();
        if (generatedFile != null && !(fileEditorManager = FileEditorManager.getInstance((Project)project)).isFileOpen(generatedFile.getVirtualFile())) {
            fileEditorManager.openEditor(new OpenFileDescriptor(project, generatedFile.getVirtualFile()), true);
        }
    }

    private static final PsiFile generateOasDraftFile(Project project, String json) {
        VirtualFile file = ExportOpenApiRootTypeKt.exportOpenApiRootType().findFile(project, FileUtil.sanitizeFileName((String)project.getName()) + "-openapi.yaml", ScratchFileService.Option.create_new_always);
        ProgressManager.checkCanceled();
        VfsUtil.saveText((VirtualFile)file, (String)json);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        Intrinsics.checkNotNull((Object)psiFile);
        return psiFile;
    }

    @RequiresReadLock
    public static final void generateOasExports(@NotNull Module module, @NotNull List<? extends EndpointsProvider<?, ?>> providers, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        OpenApiSpecification openApiSpecification = OasSerializationUtilsKt.getModuleSpecification(project, (EndpointsModuleEntity)new DefaultEndpointsModule(module), providers);
        JsonFactory jsonFactory = new JsonFactory();
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        OasSerializationUtilsKt.generateOasContent$default(jsonFactory, string, openApiSpecification, writer, false, 16, null);
    }

    @NotNull
    public static final OpenApiSpecification getModuleSpecification(@NotNull Project project, @NotNull EndpointsModuleEntity moduleEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        return OasSerializationUtilsKt.getModuleSpecification(project, moduleEntity, EndpointsProvider.Companion.getAllProviders());
    }

    /*
     * WARNING - void declaration
     */
    private static final OpenApiSpecification getModuleSpecification(Project project, EndpointsModuleEntity moduleEntity, List<? extends EndpointsProvider<?, ?>> providers) {
        void $this$flatMapTo$iv$iv;
        EndpointsProvider it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = providers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EndpointsProvider)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getEndpointType(), (Object)EndpointTypes.HTTP_SERVER_TYPE) && it.getStatus(project) != EndpointsProvider.Status.UNAVAILABLE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (EndpointsProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = OasSerializationUtilsKt.getEndpointSpecifications(project, moduleEntity, it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List it2 = (List)destination$iv$iv;
        boolean bl = false;
        return OasExportUtilsKt.squashOpenApiSpecifications((List)it2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <G, E> Collection<OpenApiSpecification> getEndpointSpecifications(Project project, EndpointsModuleEntity moduleEntity, EndpointsProvider<G, E> provider) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = provider.getEndpointGroups(project, OasSerializationUtilsKt.createFilter(moduleEntity));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Object element$iv$iv;
            Object group2 = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable $this$mapNotNull$iv = provider.getEndpoints(group2);
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                OpenApiSpecification it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Object it = element$iv$iv2;
                boolean bl3 = false;
                if (OasExportUtilsKt.getOpenApi(provider, group2, it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final EndpointsFilter createFilter(EndpointsModuleEntity moduleEntity) {
        EndpointsProjectModel projectModel = (EndpointsProjectModel)CollectionsKt.firstOrNull((List)EndpointsProjectModel.EP_NAME.getExtensionList());
        if (projectModel != null) {
            return projectModel.createFilter(moduleEntity, false, false);
        }
        Intrinsics.checkNotNull((Object)moduleEntity, (String)"null cannot be cast to non-null type com.intellij.microservices.endpoints.DefaultEndpointsModule");
        return (EndpointsFilter)new ModuleEndpointsFilter(((DefaultEndpointsModule)moduleEntity).getModule(), false, false);
    }

    @Nullable
    public static final VirtualFile generateOasSpecificationFile(@Nullable OpenApiSpecification specification, @NotNull List<String> prefixes) {
        LightVirtualFile lightVirtualFile;
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        OpenApiSpecification openApiSpecification = specification;
        if (openApiSpecification == null) {
            return null;
        }
        OpenApiSpecification oasSpecification = openApiSpecification;
        String string = OasSerializationUtilsKt.generateOasJsonSchemaForRequestBody(oasSpecification, prefixes);
        if (string == null) {
            return null;
        }
        String spec = string;
        FileType jsonFileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile $this$generateOasSpecificationFile_u24lambda_u2411 = lightVirtualFile = new LightVirtualFile("OpenapiRequestBodySchema.json", jsonFileType, (CharSequence)spec);
        boolean bl = false;
        $this$generateOasSpecificationFile_u24lambda_u2411.setWritable(false);
        return (VirtualFile)lightVirtualFile;
    }

    @NlsSafe
    @Nullable
    public static final String generateOasJsonSchemaForRequestBody(@NotNull OpenApiSpecification oasSpecification, @NotNull List<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)oasSpecification, (String)"oasSpecification");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        OasSchema oasSchema = OpenApiSpecification.findSinglePathRequestBodyData$default((OpenApiSpecification)oasSpecification, null, (int)1, null);
        if (oasSchema == null) {
            return null;
        }
        OasSchema schema2 = oasSchema;
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        ObjectNode rootNode = mapper.createObjectNode();
        Intrinsics.checkNotNull((Object)rootNode);
        ObjectNode refNode = OasSerializationUtilsKt.createNestedNodeWithSchemaPrefixes(rootNode, prefixes);
        OasSerializationUtilsKt.appendSchema(refNode, schema2);
        OasComponents components = oasSpecification.getComponents();
        if (components != null) {
            ObjectNode objectNode;
            ObjectNode $this$generateOasJsonSchemaForRequestBody_u24lambda_u2412 = objectNode = rootNode.putObject("components");
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$generateOasJsonSchemaForRequestBody_u24lambda_u2412);
            OasSerializationUtilsKt.appendComponentsToJson($this$generateOasJsonSchemaForRequestBody_u24lambda_u2412, components);
        }
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
    }

    public static /* synthetic */ String generateOasJsonSchemaForRequestBody$default(OpenApiSpecification openApiSpecification, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return OasSerializationUtilsKt.generateOasJsonSchemaForRequestBody(openApiSpecification, list);
    }

    /*
     * WARNING - void declaration
     */
    private static final ObjectNode createNestedNodeWithSchemaPrefixes(ObjectNode rootNode, List<String> prefixes) {
        Iterable $this$fold$iv = prefixes;
        boolean $i$f$fold = false;
        ObjectNode accumulator$iv = rootNode;
        for (Object element$iv : $this$fold$iv) {
            void name2;
            String string = (String)element$iv;
            ObjectNode node = accumulator$iv;
            boolean bl = false;
            node.put("type", "object");
            Intrinsics.checkNotNullExpressionValue((Object)node.putObject("properties").putObject((String)name2), (String)"putObject(...)");
        }
        return accumulator$iv;
    }

    @NlsSafe
    public static final void generateOasContent(@NotNull JsonFactory factory, @NotNull String projectName, @NotNull OpenApiSpecification openApiSpecification, @NotNull Writer writer, boolean prettyPrint) {
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ObjectMapper mapper = new ObjectMapper(factory);
        String string = FileUtil.sanitizeFileName((String)projectName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        String safeProjectName = string;
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put("openapi", "3.1.0");
        ObjectNode $this$generateOasContent_u24lambda_u2414 = objectNode = rootNode.putObject("info");
        boolean bl = false;
        $this$generateOasContent_u24lambda_u2414.put("title", safeProjectName + " API");
        $this$generateOasContent_u24lambda_u2414.put("description", safeProjectName + " API");
        $this$generateOasContent_u24lambda_u2414.put("version", "1.0.0");
        objectNode = rootNode.putArray("servers");
        Object $this$generateOasContent_u24lambda_u2415 = objectNode;
        boolean bl2 = false;
        $this$generateOasContent_u24lambda_u2415.addObject().put("url", "https://" + safeProjectName);
        List tags = openApiSpecification.getTags();
        $this$generateOasContent_u24lambda_u2415 = tags;
        if (!($this$generateOasContent_u24lambda_u2415 == null || $this$generateOasContent_u24lambda_u2415.isEmpty())) {
            Intrinsics.checkNotNull((Object)rootNode);
            OasSerializationUtilsKt.appendTags(rootNode, tags);
        }
        ObjectNode pathsNode = rootNode.putObject("paths");
        for (OasEndpointPath model : openApiSpecification.getPaths()) {
            Intrinsics.checkNotNull((Object)pathsNode);
            OasSerializationUtilsKt.appendPathToJson(pathsNode, model);
        }
        OasComponents components = openApiSpecification.getComponents();
        if (components != null && !components.getSchemas().isEmpty()) {
            ObjectNode componentsNode = rootNode.putObject("components");
            Intrinsics.checkNotNull((Object)componentsNode);
            OasSerializationUtilsKt.appendComponentsToJson(componentsNode, components);
        }
        JsonGenerator generator = factory.createGenerator(writer);
        if (prettyPrint) {
            generator.useDefaultPrettyPrinter();
        }
        mapper.writeTree(generator, (JsonNode)rootNode);
    }

    public static /* synthetic */ void generateOasContent$default(JsonFactory jsonFactory, String string, OpenApiSpecification openApiSpecification, Writer writer, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        OasSerializationUtilsKt.generateOasContent(jsonFactory, string, openApiSpecification, writer, bl);
    }

    public static final void appendPathToJson(@NotNull ObjectNode rootNode, @NotNull OasEndpointPath model) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (Intrinsics.areEqual((Object)model.getPath(), (Object)"<unknown>") && model.getOperations().isEmpty()) {
            return;
        }
        ObjectNode pathNode = rootNode.putObject(model.getAbsolutePath());
        if (model.getSummary() != null) {
            pathNode.put("summary", model.getSummary());
        }
        for (OasOperation operation : model.getOperations()) {
            Intrinsics.checkNotNull((Object)pathNode);
            OasSerializationUtilsKt.appendOperationToJson(pathNode, operation);
        }
    }

    private static final void appendOperationToJson(ObjectNode pathNode, OasOperation operation) {
        OasRequestBody requestBody;
        ObjectNode methodNode = pathNode.putObject(operation.getMethod().getMethodName());
        if (!((Collection)operation.getTags()).isEmpty()) {
            Intrinsics.checkNotNull((Object)methodNode);
            OasSerializationUtilsKt.appendOperationTags(methodNode, operation.getTags());
        }
        if (operation.getSummary() != null) {
            methodNode.put("summary", operation.getSummary());
        }
        if (operation.getDescription() != null) {
            methodNode.put("description", operation.getDescription());
        }
        if (operation.isDeprecated()) {
            methodNode.put("deprecated", true);
        }
        if (operation.getOperationId() != null) {
            methodNode.put("operationId", operation.getOperationId());
        }
        if (!operation.getParameters().isEmpty()) {
            ArrayNode parametersNode = methodNode.putArray("parameters");
            for (OasParameter parameter : operation.getParameters()) {
                OasSchema schema2;
                ObjectNode parameterNode = parametersNode.addObject();
                parameterNode.put("name", parameter.getName());
                parameterNode.put("in", parameter.getInPlace().getPlaceName());
                if (parameter.isDeprecated()) {
                    parameterNode.put("deprecated", true);
                }
                parameterNode.put("required", parameter.isRequired());
                CharSequence charSequence = parameter.getDescription();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    parameterNode.put("description", parameter.getDescription());
                }
                if ((schema2 = parameter.getSchema()) == null) continue;
                ObjectNode schemaNode = parameterNode.putObject("schema");
                Intrinsics.checkNotNull((Object)schemaNode);
                OasSerializationUtilsKt.appendSchema(schemaNode, schema2);
                if (schema2.getDefault() != null) {
                    String it;
                    boolean bl = false;
                    schemaNode.put("default", it);
                }
                OasSerializationUtilsKt.appendEnum(schemaNode, schema2);
            }
        }
        if ((requestBody = operation.getRequestBody()) != null) {
            ObjectNode requestBodyNode = methodNode.putObject("requestBody");
            ObjectNode requestBodyContentNode = requestBodyNode.putObject("content");
            Iterable $this$forEach$iv = requestBody.getContent().entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List properties;
                Map.Entry contentEntry = (Map.Entry)element$iv;
                boolean bl = false;
                String contentType = (String)contentEntry.getKey();
                OasSchema schema3 = (OasSchema)contentEntry.getValue();
                ObjectNode mediaTypeNode = requestBodyContentNode.putObject(contentType);
                ObjectNode schemaNode = mediaTypeNode.putObject("schema");
                Intrinsics.checkNotNull((Object)schemaNode);
                OasSerializationUtilsKt.appendSchema(schemaNode, schema3);
                List required = schema3.getRequired();
                if (required != null) {
                    ArrayNode requiredArray = schemaNode.putArray("required");
                    for (String it : required) {
                        requiredArray.add(it);
                    }
                }
                if (schema3.getProperties() == null) continue;
                boolean bl2 = false;
                ObjectNode propertiesNode = schemaNode.putObject("properties");
                Iterable $this$forEach$iv2 = properties;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    OasProperty property = (OasProperty)element$iv2;
                    boolean bl3 = false;
                    ObjectNode objectNode = propertiesNode.putObject(property.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"putObject(...)");
                    OasSerializationUtilsKt.appendSchema(objectNode, property.getSchema());
                }
            }
            if (requestBody.getRequired()) {
                requestBodyNode.put("required", true);
            }
        }
        if (!operation.getResponses().isEmpty()) {
            ObjectNode responsesNode = methodNode.putObject("responses");
            for (OasResponse response : operation.getResponses()) {
                Map.Entry entry;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                ObjectNode responseWithCodeNode = responsesNode.putObject(response.getCode());
                String string = response.getDescription();
                if (string == null) {
                    string = "";
                }
                responseWithCodeNode.put("description", string);
                if (!response.getContent().isEmpty()) {
                    ObjectNode contentNode = responseWithCodeNode.putObject("content");
                    $this$forEach$iv = response.getContent().entrySet();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        entry = (Map.Entry)element$iv;
                        boolean bl = false;
                        String contentType = (String)entry.getKey();
                        OasMediaTypeObject mediaTypeObject = (OasMediaTypeObject)entry.getValue();
                        ObjectNode contentTypeNode = contentNode.putObject(contentType);
                        ObjectNode objectNode = contentTypeNode.putObject("schema");
                        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"putObject(...)");
                        OasSerializationUtilsKt.appendSchema(objectNode, mediaTypeObject.getSchema());
                        if (!(!mediaTypeObject.getExamples().isEmpty())) continue;
                        ObjectNode objectNode2 = contentTypeNode.putObject("examples");
                        Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"putObject(...)");
                        OasSerializationUtilsKt.appendExamplesToJson(objectNode2, mediaTypeObject.getExamples());
                    }
                }
                if (!(!((Collection)response.getHeaders()).isEmpty())) continue;
                ObjectNode headersNode = responseWithCodeNode.putObject("headers");
                $this$forEach$iv = response.getHeaders();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    entry = (OasHeader)element$iv;
                    boolean bl = false;
                    String name2 = entry.component1();
                    boolean isRequired2 = entry.component2();
                    OasSchema schema4 = entry.component3();
                    ObjectNode headerNode = headersNode.putObject(name2);
                    headerNode.put("required", isRequired2);
                    ObjectNode objectNode = headerNode.putObject("schema");
                    Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"putObject(...)");
                    OasSerializationUtilsKt.appendSchema(objectNode, schema4);
                }
            }
        }
    }

    private static final void appendTags(ObjectNode parentNode, List<OasTag> tags) {
        ArrayNode tagsArray = parentNode.putArray("tags");
        Iterable $this$forEach$iv = tags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OasTag oasTag = (OasTag)element$iv;
            boolean bl = false;
            String name2 = oasTag.component1();
            String description2 = oasTag.component2();
            ObjectNode tagObject = tagsArray.addObject();
            tagObject.put("name", name2);
            if (!(((CharSequence)description2).length() > 0)) continue;
            tagObject.put("description", description2);
        }
    }

    private static final void appendOperationTags(ObjectNode parentNode, List<String> tags) {
        ArrayNode tagsArray = parentNode.putArray("tags");
        Iterable $this$forEach$iv = tags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            tagsArray.add(p0);
        }
    }

    private static final void appendExamplesToJson(ObjectNode parentNode, Map<String, OasExample> examples) {
        Map<String, OasExample> $this$forEach$iv = examples;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, OasExample>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String it;
            Map.Entry<String, OasExample> element$iv;
            Map.Entry<String, OasExample> entry = element$iv = iterator.next();
            boolean bl = false;
            String name2 = entry.getKey();
            OasExample example = entry.getValue();
            ObjectNode exampleObject = parentNode.putObject(name2);
            if (example.getSummary() != null) {
                boolean bl2 = false;
                exampleObject.put("summary", it);
            }
            if (example.getDescription() != null) {
                boolean bl3 = false;
                exampleObject.put("description", it);
            }
            Intrinsics.checkNotNull((Object)exampleObject);
            OasSerializationUtilsKt.appendExampleValueToJson(exampleObject, example.getValue(), "value");
        }
    }

    private static final void appendExampleValueToJson(ObjectNode exampleObject, OasExampleValue exampleValue, String fieldName) {
        OasExampleValue oasExampleValue = exampleValue;
        if (Intrinsics.areEqual((Object)oasExampleValue, (Object)OasNullValue.INSTANCE)) {
            v0 = exampleObject.put(fieldName, "null");
        } else if (oasExampleValue instanceof OasBooleanValue) {
            v0 = exampleObject.put(fieldName, ((Boolean)((OasBooleanValue)exampleValue).getValue()).booleanValue());
        } else if (oasExampleValue instanceof OasNumberValue) {
            Number value = (Number)((OasNumberValue)exampleValue).getValue();
            v0 = value instanceof Double ? exampleObject.put(fieldName, value.doubleValue()) : exampleObject.put(fieldName, ((Number)((OasNumberValue)exampleValue).getValue()).longValue());
        } else if (oasExampleValue instanceof OasStringValue) {
            v0 = exampleObject.put(fieldName, (String)((OasStringValue)exampleValue).getValue());
        } else if (oasExampleValue instanceof OasObjectValue) {
            ObjectNode objectValue = exampleObject.putObject(fieldName);
            Map $this$forEach$iv = ((OasObjectValue)exampleValue).getProperties();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = (String)entry.getKey();
                OasExampleValue value = (OasExampleValue)entry.getValue();
                Intrinsics.checkNotNull((Object)objectValue);
                OasSerializationUtilsKt.appendExampleValueToJson(objectValue, value, name2);
            }
            v0 = Unit.INSTANCE;
        } else if (oasExampleValue instanceof OasArrayValue) {
            ArrayNode arrayValue = exampleObject.putArray(fieldName);
            Iterable $this$forEach$iv = ((OasArrayValue)exampleValue).getItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OasExampleValue value = (OasExampleValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)arrayValue);
                OasSerializationUtilsKt.appendItemToArray(arrayValue, value);
            }
            v0 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void appendItemToArray(ArrayNode arrayNode, OasExampleValue exampleValue) {
        OasExampleValue oasExampleValue = exampleValue;
        if (Intrinsics.areEqual((Object)oasExampleValue, (Object)OasNullValue.INSTANCE)) {
            return;
        }
        if (oasExampleValue instanceof OasBooleanValue) {
            v0 = arrayNode.add(((Boolean)((OasBooleanValue)exampleValue).getValue()).booleanValue());
        } else if (oasExampleValue instanceof OasNumberValue) {
            Number value = (Number)((OasNumberValue)exampleValue).getValue();
            v0 = value instanceof Double ? arrayNode.add(value.doubleValue()) : arrayNode.add(((Number)((OasNumberValue)exampleValue).getValue()).longValue());
        } else if (oasExampleValue instanceof OasStringValue) {
            v0 = arrayNode.add((String)((OasStringValue)exampleValue).getValue());
        } else if (oasExampleValue instanceof OasObjectValue) {
            ObjectNode objectValue = arrayNode.addObject();
            Map $this$forEach$iv = ((OasObjectValue)exampleValue).getProperties();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String name2 = (String)entry.getKey();
                OasExampleValue value = (OasExampleValue)entry.getValue();
                Intrinsics.checkNotNull((Object)objectValue);
                OasSerializationUtilsKt.appendExampleValueToJson(objectValue, value, name2);
            }
            v0 = Unit.INSTANCE;
        } else if (oasExampleValue instanceof OasArrayValue) {
            ArrayNode arrayValue = arrayNode.addArray();
            Iterable $this$forEach$iv = ((OasArrayValue)exampleValue).getItems();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OasExampleValue value = (OasExampleValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)arrayValue);
                OasSerializationUtilsKt.appendItemToArray(arrayValue, value);
            }
            v0 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void appendComponentsToJson(ObjectNode componentsNode, OasComponents oasComponents) {
        if (!oasComponents.getSchemas().isEmpty()) {
            ObjectNode schemasNode = componentsNode.putObject("schemas");
            for (Map.Entry entry : oasComponents.getSchemas().entrySet()) {
                List required;
                String qualifiedName = (String)entry.getKey();
                OasSchema oasSchema = (OasSchema)entry.getValue();
                ObjectNode schemaNode = schemasNode.putObject(qualifiedName);
                if (oasSchema.getType() != null) {
                    OasSchemaType it;
                    boolean bl = false;
                    schemaNode.put("type", it.getTypeName());
                }
                if (oasSchema.getProperties() != null) {
                    List properties;
                    boolean bl = false;
                    ObjectNode propertiesNode = schemaNode.putObject("properties");
                    for (OasProperty property : properties) {
                        ObjectNode objectNode = propertiesNode.putObject(property.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"putObject(...)");
                        OasSerializationUtilsKt.appendSchema(objectNode, property.getSchema());
                    }
                }
                if (oasSchema.getRequired() == null) continue;
                boolean bl = false;
                ArrayNode requiredNode = schemaNode.putArray("required");
                Iterable $this$forEach$iv = required;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p0 = (String)element$iv;
                    boolean bl2 = false;
                    requiredNode.add(p0);
                }
            }
        }
    }

    private static final void appendSchema(ObjectNode parentNode, OasSchema schema2) {
        CharSequence charSequence;
        OasSerializationUtilsKt.appendSchemaTypeAndFormat(parentNode, schema2);
        if (schema2.isNullable()) {
            parentNode.put("nullable", true);
        }
        if (!((charSequence = (CharSequence)schema2.getReference()) == null || charSequence.length() == 0)) {
            parentNode.put("$ref", schema2.getReference());
        }
        OasSerializationUtilsKt.appendEnum(parentNode, schema2);
        if (schema2.getType() == OasSchemaType.ARRAY) {
            OasSchema oasSchema = schema2.getItems();
            if (oasSchema != null) {
                OasSchema itemSchema = oasSchema;
                boolean bl = false;
                ObjectNode itemsNode = parentNode.putObject("items");
                Intrinsics.checkNotNull((Object)itemsNode);
                OasSerializationUtilsKt.appendSchema(itemsNode, itemSchema);
            }
            if (schema2.isItemsUnique()) {
                parentNode.put("uniqueItems", true);
            }
        }
        if (schema2.getDefault() != null) {
            parentNode.put("default", schema2.getDefault());
        }
    }

    private static final void appendSchemaTypeAndFormat(ObjectNode schemaNode, OasSchema schema2) {
        block1: {
            OasSchemaType it;
            OasSchemaType oasSchemaType = schema2.getType();
            if (oasSchemaType != null) {
                it = oasSchemaType;
                boolean bl = false;
                schemaNode.put("type", it.getTypeName());
            }
            OasSchemaFormat oasSchemaFormat = schema2.getFormat();
            if (oasSchemaFormat == null) break block1;
            it = oasSchemaFormat;
            boolean bl = false;
            schemaNode.put("format", it.getFormatName());
        }
    }

    private static final void appendEnum(ObjectNode parentNode, OasSchema schema2) {
        block1: {
            List list = schema2.getEnum();
            if (list == null) break block1;
            List enumValues = list;
            boolean bl = false;
            ArrayNode enumNode = parentNode.putArray("enum");
            Iterable $this$forEach$iv = enumValues;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl2 = false;
                enumNode.add(p0);
            }
        }
    }

    private static final OpenApiSpecification exportOasDraft$lambda$1(OpenApiSpecification $models) {
        return $models;
    }

    private static final String exportOasDraft$lambda$5$lambda$2(Function0 $modelProvider, Project $project) {
        OpenApiSpecification openApiSpecification = (OpenApiSpecification)$modelProvider.invoke();
        if (openApiSpecification == null) {
            return null;
        }
        OpenApiSpecification models = openApiSpecification;
        String string = $project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return OasSerializationUtilsKt.generateOasDraft(string, models);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportOasDraft$lambda$5$lambda$4(Project $project, String $json, Ref $fileRef) {
        EndpointsChangeTracker.Companion this_$iv = EndpointsChangeTracker.Companion;
        boolean $i$f$withExpectedChanges = false;
        EndpointsChangeTracker publisher$iv = (EndpointsChangeTracker)$project.getMessageBus().syncPublisher(this_$iv.getTOPIC());
        publisher$iv.setTrackingChanges(false);
        try {
            boolean bl = false;
            PsiFile psiFile = OasSerializationUtilsKt.generateOasDraftFile($project, $json);
            new ReformatCodeProcessor(psiFile, false).runWithoutProgress();
            $fileRef.set((Object)psiFile);
        }
        finally {
            publisher$iv.setTrackingChanges(true);
        }
    }

    private static final void exportOasDraft$lambda$5(Project $project, Function0 $modelProvider, Ref $fileRef) {
        String string = (String)ActionsKt.runReadAction(() -> OasSerializationUtilsKt.exportOasDraft$lambda$5$lambda$2($modelProvider, $project));
        if (string == null) {
            return;
        }
        String json = string;
        WriteCommandAction.runWriteCommandAction((Project)$project, (String)MicroservicesBundle.message((String)"command.export.openapi.draft", (Object[])new Object[0]), null, () -> OasSerializationUtilsKt.exportOasDraft$lambda$5$lambda$4($project, json, $fileRef), (PsiFile[])new PsiFile[0]);
    }

    public static final /* synthetic */ String access$generateOasDraftAliased(String projectName, OpenApiSpecification models) {
        return OasSerializationUtilsKt.generateOasDraftAliased(projectName, models);
    }
}

