/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.CompareBranchesDiffPanel;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.impl.ChangesBrowserToolWindow;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitShowDiffWithBranchPanelKt;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitLocalCommitCompareInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/branch/GitShowDiffWithBranchPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "branchName", "", "repositories", "", "Lgit4idea/repo/GitRepository;", "currentBranchName", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getBranchName", "()Ljava/lang/String;", "getRepositories", "()Ljava/util/List;", "getCurrentBranchName", "disposable", "Lcom/intellij/openapi/Disposable;", "diffPanel", "Lcom/intellij/dvcs/ui/CompareBranchesDiffPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "showAsTab", "", "loadDiffInBackground", "loadDiff", "Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult;", "showDiff", "result", "LoadingResult", "intellij.vcs.git"})
public final class GitShowDiffWithBranchPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final String branchName;
    @NotNull
    private final List<GitRepository> repositories;
    @NotNull
    private final String currentBranchName;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final CompareBranchesDiffPanel diffPanel;
    @NotNull
    private final JBLoadingPanel loadingPanel;

    /*
     * WARNING - void declaration
     */
    public GitShowDiffWithBranchPanel(@NotNull Project project, @NotNull String branchName, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
        void $this$_init__u24lambda_u240;
        JBLoadingPanel jBLoadingPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)currentBranchName, (String)"currentBranchName");
        this.project = project;
        this.branchName = branchName;
        this.repositories = repositories;
        this.currentBranchName = currentBranchName;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.diffPanel = new CompareBranchesDiffPanel(this.project, (DvcsCompareSettings)GitVcsSettings.getInstance(this.project), this.branchName, this.currentBranchName);
        this.diffPanel.getChangesBrowser().hideViewerBorder();
        this.diffPanel.disableControls();
        this.diffPanel.setEmptyText("");
        ChangesBrowserBase changesBrowserBase = this.diffPanel.getChangesBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserBase, (String)"getChangesBrowser(...)");
        ChangesBrowserBase changesBrowser = changesBrowserBase;
        DiffPreview diffPreview = ChangesBrowserToolWindow.createDiffPreview((Project)this.project, (ChangesBrowserBase)changesBrowser, (Disposable)this.disposable);
        changesBrowser.setShowDiffActionPreview(diffPreview);
        JBLoadingPanel jBLoadingPanel2 = jBLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.disposable, 0, 4, null);
        GitShowDiffWithBranchPanel gitShowDiffWithBranchPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.startLoading();
        $this$_init__u24lambda_u240.add((Component)this.diffPanel);
        gitShowDiffWithBranchPanel.loadingPanel = jBLoadingPanel;
        this.loadDiffInBackground();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getBranchName() {
        return this.branchName;
    }

    @NotNull
    public final List<GitRepository> getRepositories() {
        return this.repositories;
    }

    @NotNull
    public final String getCurrentBranchName() {
        return this.currentBranchName;
    }

    public final void showAsTab() {
        Object[] objectArray = new Object[]{this.branchName};
        String string = GitBundle.message("show.diff.between.dialog.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        Content content = ContentFactory.getInstance().createContent((JComponent)this.loadingPanel, title, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setPreferredFocusableComponent(this.diffPanel.getPreferredFocusComponent());
        content2.setDisposer(this.disposable);
        ChangesBrowserToolWindow.showTab((Project)this.project, (Content)content2);
    }

    private final void loadDiffInBackground() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().executeOnPooledThread(() -> GitShowDiffWithBranchPanel.loadDiffInBackground$lambda$2(this));
    }

    private final LoadingResult loadDiff() {
        try {
            GitLocalCommitCompareInfo compareInfo = new GitLocalCommitCompareInfo(this.project, this.branchName);
            for (GitRepository repository : this.repositories) {
                compareInfo.putTotalDiff(repository, GitBranchWorker.loadTotalDiff(repository, this.branchName));
            }
            return new LoadingResult.Success(compareInfo);
        }
        catch (Exception e) {
            GitShowDiffWithBranchPanelKt.access$getLOG$p().warn((Throwable)e);
            Object[] objectArray = new Object[]{this.branchName, e.getMessage()};
            String string = GitBundle.message("show.diff.between.dialog.could.not.load.diff.with.branch.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new LoadingResult.Error(string);
        }
    }

    private final void showDiff(LoadingResult result2) {
        if (Disposer.isDisposed((Disposable)this.disposable)) {
            return;
        }
        this.loadingPanel.stopLoading();
        LoadingResult loadingResult = result2;
        if (loadingResult instanceof LoadingResult.Success) {
            this.diffPanel.setCompareInfo((CommitCompareInfo)((LoadingResult.Success)result2).getCompareInfo());
            this.diffPanel.setEmptyText(GitBundle.message("show.diff.between.dialog.no.differences.empty.text", new Object[0]));
            this.diffPanel.enableControls();
        } else if (loadingResult instanceof LoadingResult.Error) {
            Messages.showErrorDialog((Component)((Component)this.diffPanel), (String)((LoadingResult.Error)result2).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final Unit loadDiffInBackground$lambda$2$lambda$1(GitShowDiffWithBranchPanel this$0, LoadingResult $result) {
        this$0.showDiff($result);
        return Unit.INSTANCE;
    }

    private static final void loadDiffInBackground$lambda$2(GitShowDiffWithBranchPanel this$0) {
        LoadingResult result2 = this$0.loadDiff();
        ActionsKt.runInEdt$default(null, () -> GitShowDiffWithBranchPanel.loadDiffInBackground$lambda$2$lambda$1(this$0, result2), (int)1, null);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult;", "", "<init>", "()V", "Success", "Error", "Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult$Error;", "Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult$Success;", "intellij.vcs.git"})
    private static abstract class LoadingResult {
        private LoadingResult() {
        }

        public /* synthetic */ LoadingResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult$Error;", "Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult;", "error", "", "<init>", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Error
        extends LoadingResult {
            @NotNull
            private final String error;

            public Error(@Nls @NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final String getError() {
                return this.error;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult$Success;", "Lgit4idea/branch/GitShowDiffWithBranchPanel$LoadingResult;", "compareInfo", "Lgit4idea/util/GitLocalCommitCompareInfo;", "<init>", "(Lgit4idea/util/GitLocalCommitCompareInfo;)V", "getCompareInfo", "()Lgit4idea/util/GitLocalCommitCompareInfo;", "intellij.vcs.git"})
        public static final class Success
        extends LoadingResult {
            @NotNull
            private final GitLocalCommitCompareInfo compareInfo;

            public Success(@NotNull GitLocalCommitCompareInfo compareInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)compareInfo), (String)"compareInfo");
                super(null);
                this.compareInfo = compareInfo;
            }

            @NotNull
            public final GitLocalCommitCompareInfo getCompareInfo() {
                return this.compareInfo;
            }
        }
    }
}

