/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransferHolder<T> {
    @Nullable
    private T datum = null;

    public synchronized void offer(@NotNull T datum) {
        if (datum == null) {
            TransferHolder.$$$reportNull$$$0(0);
        }
        this.datum = datum;
        this.notifyAll();
    }

    public synchronized boolean offerIfEmpty(@NotNull T datum) {
        if (datum == null) {
            TransferHolder.$$$reportNull$$$0(1);
        }
        boolean accepted = false;
        if (this.datum == null) {
            this.datum = datum;
            accepted = true;
            this.notifyAll();
        }
        return accepted;
    }

    @Nullable
    public synchronized T take(long timeout) throws InterruptedException {
        long t0 = System.currentTimeMillis();
        long tR = t0 + timeout;
        T d = this.datum;
        try {
            if (d != null || timeout == 0L) {
                T t = d;
                return t;
            }
            while (true) {
                long toWait;
                if ((toWait = tR - System.currentTimeMillis()) <= 0L) {
                    T t = null;
                    return t;
                }
                this.wait(toWait);
                d = this.datum;
                if (d == null) continue;
                T t = d;
                return t;
            }
        }
        finally {
            this.datum = null;
        }
    }

    synchronized T peekDatum() {
        return this.datum;
    }

    public synchronized boolean isEmpty() {
        return this.datum == null;
    }

    public synchronized void clear() {
        this.datum = null;
    }

    public String toString() {
        T d = this.peekDatum();
        return d != null ? d.toString() : "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "datum";
        objectArray2[1] = "com/intellij/database/dialects/oracle/debugger/TransferHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "offer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "offerIfEmpty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

