/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.introspector;

import com.intellij.database.dialects.oracle.introspector.MajorMinorName;
import com.intellij.database.dialects.oracle.introspector.MajorNameMinorId;
import com.intellij.database.dialects.oracle.introspector.OraMajorSourceText;
import com.intellij.database.remote.jdba.util.Numbers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a,\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u001a$\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0010H\u0000\u001a$\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0010H\u0000\u00a8\u0006\u0014"}, d2={"splitByPacks", "", "E", "", "limit", "", "quoteAsOraLiteral", "", "parseMajorSources", "", "xmlText", "", "container", "", "Lcom/intellij/database/dialects/oracle/introspector/OraMajorSourceText;", "parseMinorSources", "", "Lcom/intellij/database/dialects/oracle/introspector/MajorMinorName;", "parseTriggerSources", "Lcom/intellij/database/dialects/oracle/introspector/MajorNameMinorId;", "intellij.database.dialects.oracle"})
public final class OraIntrospectorSourcesHelperKt {
    @NotNull
    public static final <E> List<List<E>> splitByPacks(@NotNull Collection<? extends E> $this$splitByPacks, int limit) {
        Intrinsics.checkNotNullParameter($this$splitByPacks, (String)"<this>");
        if ($this$splitByPacks instanceof List) {
            return OraIntrospectorSourcesHelperKt.splitByPacks((List)$this$splitByPacks, limit);
        }
        ArrayList<E> list = new ArrayList<E>($this$splitByPacks.size());
        list.addAll($this$splitByPacks);
        return OraIntrospectorSourcesHelperKt.splitByPacks((List)list, limit);
    }

    @NotNull
    public static final <E> List<List<E>> splitByPacks(@NotNull List<? extends E> $this$splitByPacks, int limit) {
        Intrinsics.checkNotNullParameter($this$splitByPacks, (String)"<this>");
        int n = $this$splitByPacks.size();
        if (n <= limit) {
            List<List<E>> list = Collections.singletonList($this$splitByPacks);
            Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
            return list;
        }
        int m = n / limit + (n % limit > 0 ? 1 : 0);
        int p2size = n / m;
        int p1size = p2size + 1;
        int p1cnt = n % m;
        ArrayList<List<? extends E>> result2 = new ArrayList<List<? extends E>>(m);
        int offset = 0;
        int i2 = 1;
        if (i2 <= m) {
            while (true) {
                int ps = i2 <= p1cnt ? p1size : p2size;
                List<? extends E> pack = $this$splitByPacks.subList(offset, offset + ps);
                result2.add(pack);
                offset += ps;
                if (i2 == m) break;
                ++i2;
            }
        }
        return result2;
    }

    @NotNull
    public static final String quoteAsOraLiteral(@NotNull String $this$quoteAsOraLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteAsOraLiteral, (String)"<this>");
        return "'" + StringsKt.replace$default((String)$this$quoteAsOraLiteral, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    public static final void parseMajorSources(@NotNull CharSequence xmlText, @NotNull Collection<OraMajorSourceText> container) {
        Intrinsics.checkNotNullParameter((Object)xmlText, (String)"xmlText");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Regex pattern = new Regex("<_:object_element:_>\\s*<_:major_name:_>(.+?)</_:major_name:_>\\s*<_:content_text:_>(.+?)</_:content_text:_>\\s*</_:object_element:_>", RegexOption.DOT_MATCHES_ALL);
        for (MatchResult m = Regex.find$default((Regex)pattern, (CharSequence)xmlText, (int)0, (int)2, null); m != null; m = m.next()) {
            String name2 = (String)m.getGroupValues().get(1);
            String text2 = (String)m.getGroupValues().get(2);
            container.add(new OraMajorSourceText(name2, text2));
        }
    }

    public static final void parseMinorSources(@NotNull CharSequence xmlText, @NotNull Map<MajorMinorName, String> container) {
        Intrinsics.checkNotNullParameter((Object)xmlText, (String)"xmlText");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Regex pattern = new Regex("<_:object_element:_>\\s*<_:major_name:_>(.+?)</_:major_name:_>\\s*<_:minor_name:_>(.+?)</_:minor_name:_>\\s*<_:content_text:_>(.+?)</_:content_text:_>\\s*</_:object_element:_>", RegexOption.DOT_MATCHES_ALL);
        for (MatchResult m = Regex.find$default((Regex)pattern, (CharSequence)xmlText, (int)0, (int)2, null); m != null; m = m.next()) {
            String major = (String)m.getGroupValues().get(1);
            String minor = (String)m.getGroupValues().get(2);
            String content = (String)m.getGroupValues().get(3);
            container.put(new MajorMinorName(major, minor), content);
        }
    }

    public static final void parseTriggerSources(@NotNull CharSequence xmlText, @NotNull Map<MajorNameMinorId, String> container) {
        Intrinsics.checkNotNullParameter((Object)xmlText, (String)"xmlText");
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Regex pattern = new Regex("<_:object_element:_>\\s*<_:major_name:_>(.+?)</_:major_name:_>\\s*<_:minor_id:_>\\s*(.+?)\\s*</_:minor_id:_>\\s*<_:content_text:_>(.+?)</_:content_text:_>\\s*</_:object_element:_>", RegexOption.DOT_MATCHES_ALL);
        for (MatchResult m = Regex.find$default((Regex)pattern, (CharSequence)xmlText, (int)0, (int)2, null); m != null; m = m.next()) {
            String majorName = (String)m.getGroupValues().get(1);
            String minorStr = (String)m.getGroupValues().get(2);
            String content = (String)m.getGroupValues().get(3);
            long minorId = Numbers.parseLongSafe((String)minorStr);
            if (minorId == 0L) continue;
            container.put(new MajorNameMinorId(majorName, minorId), content);
        }
    }
}

