/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.owner;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.owner.ElementOwnerImpl;
import com.intellij.database.schemaEditor.owner.Id;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ElementOwnerPullHelper {
    private final ElementOwnerImpl myTargetOwner;
    private final ElementOwnerImpl myOriginalOwner;

    ElementOwnerPullHelper(@NotNull ElementOwnerImpl targetOwner, @NotNull ElementOwnerImpl originalOwner) {
        if (targetOwner == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(0);
        }
        if (originalOwner == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(1);
        }
        this.myTargetOwner = targetOwner;
        this.myOriginalOwner = originalOwner;
    }

    ElementOwnerImpl getOriginalOwner() {
        return this.myOriginalOwner;
    }

    @Nullable
    <E extends BasicElement> E pullFromOriginal(@NotNull Id<E> id) {
        E orig;
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(2);
        }
        if ((orig = this.myOriginalOwner.findElement(id)) == null) {
            return null;
        }
        Id<?> parentId = id.getParentId();
        if (parentId == null) {
            return this.pullRootLikeObject(id, orig);
        }
        Object parent = this.myTargetOwner.find(parentId);
        if (parent == null) {
            return null;
        }
        if (id.getInlined() != null) {
            E res2 = ElementOwnerPullHelper.findInlined(parent, id);
            if (res2 != null) {
                this.myTargetOwner.addResolution(id, res2);
            }
            return res2;
        }
        E res3 = this.pullRootLikeObject(id, orig);
        if (res3 != null) {
            return res3;
        }
        this.pull(id, (BasicElement)parent, orig);
        return this.myTargetOwner.findElement(id);
    }

    <E extends BasicElement> void addMatchAndPull(@NotNull Id<E> id, E res2) {
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(3);
        }
        Id<?> parentId = id.getParentId();
        BasicElement parent = res2.getParent();
        if (parentId != null && parent != null) {
            this.addMatchAndPull(parentId, parent);
        }
        this.myTargetOwner.addResolution(id, res2);
        E orig = this.myOriginalOwner.findElement(id);
        if (orig != null) {
            this.pullElementTo(id, res2, orig);
        }
    }

    @Nullable
    private <E extends BasicElement> E pullRootLikeObject(@NotNull Id<E> id, E orig) {
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(4);
        }
        if (orig instanceof BasicRoot) {
            return this.pullModelRoot(id, orig);
        }
        if (orig instanceof BasicDataObject) {
            E res2 = BasicMetaUtils.getMetaObject(orig).newDataObject();
            this.pullElementProperties(id, res2, orig);
            return res2;
        }
        return null;
    }

    @NotNull
    private <E extends BasicElement> E pullModelRoot(Id<E> id, E orig) {
        Object model = orig.getMetaObject().getModel().newModel();
        BaseModel.setResolveAssistant(model, this.myTargetOwner.getResolveAssistant());
        BasicRoot root = model.getRoot();
        this.pullElementTo(id, root, orig);
        BasicRoot basicRoot = root;
        if (basicRoot == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(5);
        }
        return (E)basicRoot;
    }

    <E extends BasicModElement> void fillFamilyUsingOriginal(Id<?> parentId, BasicMetaObject<E> meta, ModFamily<E> family) {
        Object origParent = this.myOriginalOwner.findElement(parentId);
        Family<?> srcFamily = origParent == null ? null : (Family<?>)BasicMetaUtils.getFamily(origParent, meta);
        this.pullFamily(family, srcFamily);
    }

    private <E extends BasicElement> void pull(@NotNull Id<E> id, @NotNull BasicElement parent, @NotNull E orig) {
        BasicModel model;
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(7);
        }
        if (orig == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(8);
        }
        if (parent instanceof BasicHierarchicalObject) {
            BasicHierarchicalObject h = (BasicHierarchicalObject)parent;
            v0 = h.getModel();
        } else {
            v0 = model = null;
        }
        if (model == null) {
            this.pullImpl(id, parent, orig);
        } else {
            model.modify(BasicModRoot.class, r -> this.pullImpl(id, parent, orig));
        }
    }

    private <E extends BasicElement> void pullImpl(@NotNull Id<E> id, @NotNull BasicElement parent, @NotNull E orig) {
        ModFamily tgtFamily;
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(10);
        }
        if (orig == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(11);
        }
        if ((tgtFamily = (ModFamily)parent.familyOf(orig.getKind())) == null || tgtFamily.getMetaObject() != orig.getMetaObject()) {
            return;
        }
        if (orig instanceof BasicArrangedElement) {
            this.pullFamily(tgtFamily, orig.getParentFamily());
        } else {
            this.pullElement(id, tgtFamily, orig);
        }
    }

    private void pullFamily(@Nullable ModFamily<?> tgtFamily, @Nullable Family<?> srcFamily) {
        if (tgtFamily == null || srcFamily == null || !tgtFamily.isEmpty()) {
            return;
        }
        for (BasicElement srcE : srcFamily) {
            this.pullElement((Id)this.myOriginalOwner.identify(srcE), tgtFamily, (BasicElement)srcE);
        }
    }

    private <E extends BasicElement> void pullElement(@NotNull Id<E> id, @Nullable ModFamily<?> tgtFamily, E srcE) {
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(12);
        }
        if (tgtFamily == null) {
            return;
        }
        Object tgtE = tgtFamily.createNewOne();
        this.pullElementTo(id, (E)tgtE, srcE);
    }

    private <E extends BasicElement> void pullElementTo(@NotNull Id<E> id, E tgtE, E srcE) {
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(13);
        }
        this.pullElementProperties(id, tgtE, srcE);
        if (tgtE instanceof DasRoutine || tgtE instanceof DasTable) {
            this.pullFamilies(tgtE, srcE);
        } else {
            this.pullGrantHolderChildren(tgtE, srcE);
        }
    }

    private <E extends BasicElement> void pullGrantHolderChildren(E tgtE, E srcE) {
        for (Family<? extends BasicElement> family : srcE.getFamilies()) {
            if (!family.getMetaObject().kindOf(BasicGrantsHolder.class)) continue;
            this.pullFamilyTo(tgtE, family);
        }
    }

    private <E extends BasicElement> void pullElementProperties(Id<E> id, E tgtE, E srcE) {
        ModelLightCopier.copyProperties(srcE, (BasicModElement)tgtE, true, true);
        this.myTargetOwner.addResolution(id, tgtE);
        this.processInlineReferences(tgtE, srcE);
    }

    private <E extends BasicElement> void processInlineReferences(E tgtE, E srcE) {
        BasicMetaUtils.makeInlinesMutable(tgtE);
        for (BasicMetaReference ref2 : BasicMetaUtils.getMetaObject(tgtE).getAllProperties().filterMap(BasicMetaReference::asRef)) {
            this.addInlineRefResolution(tgtE, srcE, ref2);
        }
    }

    private <E extends BasicElement, T extends BasicElement> void addInlineRefResolution(E tgtE, E srcE, BasicMetaReference<E, T> metaRef) {
        if (metaRef.isAbstract()) {
            return;
        }
        BasicReference tgt = (BasicReference)metaRef.get(tgtE);
        BasicReference src = (BasicReference)metaRef.get(srcE);
        if (tgt instanceof BasicInlineObjectReference) {
            BasicInlineObjectReference tgtI = (BasicInlineObjectReference)tgt;
            if (src instanceof BasicInlineObjectReference) {
                BasicInlineObjectReference srcI = (BasicInlineObjectReference)src;
                Object tgtObj = tgtI.getInlineData(metaRef.getReferenceDesc());
                Object srcObj = srcI.getInlineData(metaRef.getReferenceDesc());
                if (tgtObj != null && srcObj != null) {
                    ElementIdentity origId = this.myOriginalOwner.identifyInlineRef(srcE, (BasicMetaReference)metaRef, (BasicElement)srcObj);
                    if (((BasicDataObject)tgtObj).isFrozen()) {
                        throw new AssertionError((Object)"Should be mutable");
                    }
                    this.myTargetOwner.addResolution(origId, tgtObj);
                }
            }
        }
    }

    private void pullFamilies(BasicElement tgtE, BasicElement srcE) {
        for (Family<? extends BasicElement> family : srcE.getFamilies()) {
            this.pullFamilyTo(tgtE, family);
        }
    }

    private void pullFamilyTo(BasicElement tgtE, Family<? extends BasicElement> srcF) {
        this.pullFamily((ModFamily)tgtE.familyOf(srcF.getMetaObject().kind), srcF);
    }

    @Nullable
    private static <E extends BasicElement> E findInlined(BasicElement p2, @NotNull Id<E> id) {
        BasicMetaReference<BasicElement, BasicElement> metaRef;
        if (id == null) {
            ElementOwnerPullHelper.$$$reportNull$$$0(14);
        }
        if ((metaRef = id.getInlined(p2)) == null) {
            return null;
        }
        BasicReference ref2 = (BasicReference)metaRef.get(p2);
        BasicInlineObjectReference inline = (BasicInlineObjectReference)ObjectUtils.tryCast((Object)ref2, BasicInlineObjectReference.class);
        return inline == null ? null : (E)inline.getInlineData(metaRef.getReferenceDesc());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalOwner";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/owner/ElementOwnerPullHelper";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/owner/ElementOwnerPullHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "pullModelRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pullFromOriginal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMatchAndPull";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pullRootLikeObject";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pull";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "pullImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pullElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pullElementTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findInlined";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

