/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.DefaultInjectedLanguageBlockBuilder;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelMaker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J<\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/model/SqlInjectedLanguageBlockBuilder;", "Lcom/intellij/psi/formatter/common/DefaultInjectedLanguageBlockBuilder;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "hostBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "<init>", "(Lcom/intellij/sql/formatter/model/SqlFormattingContext;Lcom/intellij/sql/formatter/model/SqlBlock;)V", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "addInjectedLanguageBlockWrapper", "", "result", "", "Lcom/intellij/formatting/Block;", "injectedNode", "Lcom/intellij/lang/ASTNode;", "indent", "Lcom/intellij/formatting/Indent;", "offset", "", "range", "Lcom/intellij/openapi/util/TextRange;", "makeSameLanguageOriginalBlock", "node", "makeAlienOriginalBlock", "language", "Lcom/intellij/lang/Language;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlInjectedLanguageBlockBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlInjectedLanguageBlockBuilder.kt\ncom/intellij/sql/formatter/model/SqlInjectedLanguageBlockBuilder\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,62:1\n108#2:63\n80#2,22:64\n*S KotlinDebug\n*F\n+ 1 SqlInjectedLanguageBlockBuilder.kt\ncom/intellij/sql/formatter/model/SqlInjectedLanguageBlockBuilder\n*L\n34#1:63\n34#1:64,22\n*E\n"})
public final class SqlInjectedLanguageBlockBuilder
extends DefaultInjectedLanguageBlockBuilder {
    @NotNull
    private final SqlFormattingContext context;
    @NotNull
    private final SqlBlock hostBlock;

    public SqlInjectedLanguageBlockBuilder(@NotNull SqlFormattingContext context, @NotNull SqlBlock hostBlock) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hostBlock, (String)"hostBlock");
        super(context.getSettingsContainer());
        this.context = context;
        this.hostBlock = hostBlock;
    }

    @NotNull
    public final SqlFormattingContext getContext() {
        return this.context;
    }

    public void addInjectedLanguageBlockWrapper(@NotNull List<? super Block> result2, @NotNull ASTNode injectedNode, @Nullable Indent indent, int offset, @Nullable TextRange range) {
        block14: {
            Block original;
            Language childLanguage;
            block13: {
                block12: {
                    Block block;
                    Intrinsics.checkNotNullParameter(result2, (String)"result");
                    Intrinsics.checkNotNullParameter((Object)injectedNode, (String)"injectedNode");
                    if (range != null) {
                        if (range.getLength() == 0) {
                            return;
                        }
                        String string = range.substring(injectedNode.getText());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String subText = string;
                        if (StringsKt.isBlank((CharSequence)subText)) {
                            return;
                        }
                    }
                    PsiElement childElement = injectedNode.getPsi();
                    Language language = childElement.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                    childLanguage = language;
                    if (Intrinsics.areEqual((Object)childLanguage, (Object)this.context.getDialect())) {
                        block = this.makeSameLanguageOriginalBlock(injectedNode);
                    } else {
                        Intrinsics.checkNotNull((Object)childElement);
                        block = this.makeAlienOriginalBlock(childLanguage, childElement);
                        if (block == null) {
                            return;
                        }
                    }
                    original = block;
                    if (!original.isLeaf()) break block12;
                    String string = injectedNode.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String $this$trim$iv = string;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block13;
                }
                if (original.getSubBlocks().isEmpty()) break block14;
            }
            Block block = this.createInjectedBlock(injectedNode, original, indent, offset, range, childLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"createInjectedBlock(...)");
            result2.add((Block)block);
        }
    }

    private final SqlBlock makeSameLanguageOriginalBlock(ASTNode node) {
        PsiFile file = node.getPsi().getContainingFile();
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        Intrinsics.checkNotNull((Object)file);
        CodeStyleSettings codeStyleSettings = this.context.getSettingsContainer();
        FormattingMode formattingMode = this.context.getMode();
        TextRange textRange = file.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        SqlFormattingModelMaker maker = new SqlFormattingModelMaker(charSequence, file, codeStyleSettings, formattingMode, textRange);
        return maker.makeDomesticSubModel(this.hostBlock, node);
    }

    private final Block makeAlienOriginalBlock(Language language, PsiElement element) {
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext(language, element);
        if (formattingModelBuilder == null) {
            return null;
        }
        FormattingModelBuilder builder = formattingModelBuilder;
        FormattingModel formattingModel = builder.createModel(FormattingContext.create((PsiElement)element, (CodeStyleSettings)this.getSettings()));
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"createModel(...)");
        FormattingModel childModel2 = formattingModel;
        return childModel2.getRootBlock();
    }
}

