/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedLockSupport
implements NamedLock {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final NamedLockFactorySupport factory;
    private final ConcurrentHashMap<Thread, Deque<String>> diagnosticState;

    public NamedLockSupport(String name2, NamedLockFactorySupport factory) {
        this.name = name2;
        this.factory = factory;
        this.diagnosticState = factory.isDiagnosticEnabled() ? new ConcurrentHashMap() : null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean lockShared(long time, TimeUnit unit) throws InterruptedException {
        Deque steps = null;
        if (this.diagnosticState != null) {
            steps = this.diagnosticState.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque());
        }
        if (steps != null) {
            steps.push("wait-shared");
        }
        boolean result2 = this.doLockShared(time, unit);
        if (steps != null) {
            steps.pop();
            if (result2) {
                steps.push("shared");
            }
        }
        return result2;
    }

    protected abstract boolean doLockShared(long var1, TimeUnit var3) throws InterruptedException;

    @Override
    public boolean lockExclusively(long time, TimeUnit unit) throws InterruptedException {
        Deque steps = null;
        if (this.diagnosticState != null) {
            steps = this.diagnosticState.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque());
        }
        if (steps != null) {
            steps.push("wait-exclusive");
        }
        boolean result2 = this.doLockExclusively(time, unit);
        if (steps != null) {
            steps.pop();
            if (result2) {
                steps.push("exclusive");
            }
        }
        return result2;
    }

    protected abstract boolean doLockExclusively(long var1, TimeUnit var3) throws InterruptedException;

    @Override
    public void unlock() {
        this.doUnlock();
        if (this.diagnosticState != null) {
            this.diagnosticState.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque()).pop();
        }
    }

    protected abstract void doUnlock();

    @Override
    public void close() {
        this.doClose();
    }

    protected void doClose() {
        this.factory.closeLock(this.name);
    }

    public Map<Thread, Deque<String>> diagnosticState() {
        if (this.diagnosticState != null) {
            return this.diagnosticState;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + '}';
    }
}

