/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.xml.XmlFormattingModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueBlock;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueHtmlBlock;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueHtmlTagBlock;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueRootFormattingPolicy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/lang/html/psi/formatter/VueFormattingModelBuilder;", "Lcom/intellij/formatting/FormattingModelBuilder;", "<init>", "()V", "createModel", "Lcom/intellij/formatting/FormattingModel;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "intellij.vuejs"})
public final class VueFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        FormattingModel formattingModel;
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        PsiFile psiFile = formattingContext.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile psiFile2 = psiFile;
        boolean vueFile = VueFileTypeKt.isVueFile(psiFile2);
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile2);
        PsiElement psiElement = formattingContext.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        PsiElement element = psiElement;
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        if (element instanceof XmlTag) {
            ASTNode aSTNode = ((XmlTag)element).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
            formattingModel = (FormattingModel)new XmlFormattingModel(psiFile2, (Block)new VueHtmlTagBlock(aSTNode, null, null, (XmlFormattingPolicy)new HtmlPolicy(settings, (FormattingDocumentModel)documentModel), null, false), documentModel);
        } else {
            XmlBlock xmlBlock;
            if (vueFile) {
                FileASTNode fileASTNode = psiFile2.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
                ASTNode aSTNode = (ASTNode)fileASTNode;
                Intrinsics.checkNotNull((Object)documentModel);
                xmlBlock = new VueBlock(aSTNode, null, null, new VueRootFormattingPolicy(settings, (FormattingDocumentModel)documentModel), null, null, false);
            } else {
                FileASTNode fileASTNode = psiFile2.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
                xmlBlock = new VueHtmlBlock((ASTNode)fileASTNode, null, null, (XmlFormattingPolicy)new HtmlPolicy(settings, (FormattingDocumentModel)documentModel), null, null, false);
            }
            formattingModel = (FormattingModel)new XmlFormattingModel(psiFile2, (Block)xmlBlock, documentModel);
        }
        return formattingModel;
    }
}

