/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.SearchResultsTreeModelFactory;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindResultsWithOneTree {
    private final Project myProject;
    private final V8CachingReader myReader;
    private final int myNumResults;
    private final V8MainTreeNavigator myNavigator;
    private SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> myByStringsModel;
    private SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> myByTypes;
    private V8HeapTreeTable myTable;

    public FindResultsWithOneTree(Project project, V8CachingReader reader, int numResults, V8MainTreeNavigator navigator) {
        this.myProject = project;
        this.myReader = reader;
        this.myNumResults = numResults;
        this.myNavigator = navigator;
    }

    public DataProviderPanel showMe(SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> byStringsModel, SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> byTypes) {
        this.myByStringsModel = byStringsModel;
        this.myByTypes = byTypes;
        this.myTable = V8Utils.createTable(this.myProject, byTypes, this.myReader);
        V8Utils.installHeapPopupMenu(this.myProject, this.myTable, this.myReader, this.myNavigator);
        DataProviderPanel wrapper = DataProviderPanel.wrap((JComponent)new JBScrollPane((Component)((Object)this.myTable)), sink -> this.fillDataContext(sink, this.myTable));
        this.myTable.getSelectionModel().setSelectionMode(0);
        return wrapper;
    }

    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new GroupByAction());
        MarkUnmarkAction markUnmarkAction = new MarkUnmarkAction(this.myProject, this.myReader);
        markUnmarkAction.setTable(this.myTable);
        group.add((AnAction)markUnmarkAction);
        V8NavigateToMainTreeAction toMainTreeAction = new V8NavigateToMainTreeAction();
        toMainTreeAction.setTable(this.myTable);
        group.add((AnAction)toMainTreeAction);
        group.add((AnAction)new GoToSourceAction(this.myReader, this.myTable));
        group.add((AnAction)new V8Utils.ExpandAllAction(this.myTable));
        group.add((AnAction)new V8Utils.CollapseAllAction(this.myTable));
    }

    public void defaultExpand() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myNumResults <= 10) {
                TreeUtil.expandAll((JTree)this.myTable.getTree());
            } else {
                SearchResultsTreeModelFactory.expandTop(this.myTable.getTree(), this.myTable.getTableModel());
            }
            if (this.myByStringsModel.getChildCount(this.myByStringsModel.getRoot()) > 0) {
                this.myTable.addRowSelectionInterval(0, 0);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTable), true));
        });
    }

    private void fillDataContext(@NotNull DataSink sink, V8HeapTreeTable table) {
        if (sink == null) {
            FindResultsWithOneTree.$$$reportNull$$$0(0);
        }
        sink.set(V8NavigateToMainTreeAction.TREE_PATH, (Object)FindResultsWithOneTree.convert(table, node -> {
            FixedRetainerNode o;
            ArrayList<V8HeapContainmentTreeTableModel.NamedEntry> list = new ArrayList<V8HeapContainmentTreeTableModel.NamedEntry>();
            TreePath value = table.getTree().getSelectionPath();
            if (value == null) {
                return null;
            }
            ChainTreeTableModel.Node current = (ChainTreeTableModel.Node)value.getLastPathComponent();
            Object patt4890$temp = current.getT();
            if (patt4890$temp instanceof FixedRetainerNode && (o = (FixedRetainerNode)patt4890$temp).isUnreachable()) {
                return null;
            }
            while (true) {
                list.add((V8HeapContainmentTreeTableModel.NamedEntry)current.getT());
                if (current.getChildren().isEmpty()) break;
                current = current.getChildren().get(0);
            }
            list.add(new V8HeapContainmentTreeTableModel.NamedEntry(this.myReader.getNode(0L), "", "", -1L));
            Collections.reverse(list);
            return new TreePath(ArrayUtil.toObjectArray(list));
        }));
        sink.set(MarkUnmarkAction.SELECTED_NODE, (Object)FindResultsWithOneTree.convert(table, o -> o.getEntry()));
        sink.set(MarkUnmarkAction.UNREACHABLE_NODE, (Object)FindResultsWithOneTree.convert(table, o -> o.isUnreachable() ? Boolean.TRUE : null));
        sink.set(MarkUnmarkAction.SELECTED_LINK, (Object)FindResultsWithOneTree.convert(table, o -> o.getLinkOffset() / 37L));
        sink.set(MarkUnmarkAction.REVALIDATION, () -> {
            table.revalidate();
            table.repaint();
        });
    }

    @Nullable
    private static <T> T convert(@NotNull V8HeapTreeTable table, @NotNull Function<FixedRetainerNode, T> fun) {
        ChainTreeTableModel.Node node;
        Object object;
        TreePath value;
        if (table == null) {
            FindResultsWithOneTree.$$$reportNull$$$0(1);
        }
        if (fun == null) {
            FindResultsWithOneTree.$$$reportNull$$$0(2);
        }
        if ((value = table.getTree().getSelectionPath()) != null && (object = value.getLastPathComponent()) instanceof ChainTreeTableModel.Node && (node = (ChainTreeTableModel.Node)object).getT() instanceof FixedRetainerNode) {
            return fun.apply((FixedRetainerNode)node.getT());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/FindResultsWithOneTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillDataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class GroupByAction
    extends ToggleAction {
        private boolean myIsGroupedByType;

        GroupByAction() {
            super(NodeJSBundle.messagePointer("action.GroupByAction.group.by.type.text", new Object[0]), NodeJSBundle.messagePointer("action.GroupByAction.group.by.type.text", new Object[0]), AllIcons.Actions.GroupByPrefix);
            this.myIsGroupedByType = true;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GroupByAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupByAction.$$$reportNull$$$0(1);
            }
            return this.myIsGroupedByType;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                GroupByAction.$$$reportNull$$$0(2);
            }
            this.myIsGroupedByType = state;
            if (this.myIsGroupedByType) {
                FindResultsWithOneTree.this.myTable.setModel(FindResultsWithOneTree.this.myByTypes);
            } else {
                FindResultsWithOneTree.this.myTable.setModel(FindResultsWithOneTree.this.myByStringsModel);
            }
            V8Utils.afterModelReset(FindResultsWithOneTree.this.myProject, FindResultsWithOneTree.this.myReader, FindResultsWithOneTree.this.myTable);
            FindResultsWithOneTree.this.myTable.revalidate();
            FindResultsWithOneTree.this.myTable.repaint();
            FindResultsWithOneTree.this.defaultExpand();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/components/FindResultsWithOneTree$GroupByAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/FindResultsWithOneTree$GroupByAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

