/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.toolwindow.packages;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowService;
import java.awt.Dimension;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/packages/PyPackageSearchTextField;", "Lcom/intellij/ui/SearchTextField;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "service", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;", "getService", "()Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;", "searchAlarm", "Lcom/intellij/util/SingleAlarm;", "getSearchAlarm", "()Lcom/intellij/util/SingleAlarm;", "onFieldCleared", "", "intellij.python.community.impl"})
public final class PyPackageSearchTextField
extends SearchTextField {
    @NotNull
    private final Project project;
    @NotNull
    private final SingleAlarm searchAlarm;

    public PyPackageSearchTextField(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(true);
        this.project = project;
        Runnable runnable = () -> PyPackageSearchTextField.searchAlarm$lambda$0(this);
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        CoroutineScope coroutineScope = this.getService().getServiceScope();
        ModalityState modalityState = ModalityState.nonModal();
        this.searchAlarm = new SingleAlarm(runnable, 500, null, threadToUse, modalityState, coroutineScope);
        this.setHistoryPropertyName("PyPackageSearchTextField.history");
        this.setHistorySize(10);
        this.setPreferredSize(new Dimension(250, 30));
        this.setMinimumSize(new Dimension(250, 30));
        this.setMaximumSize(new Dimension(250, 30));
        this.getTextEditor().setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        this.getTextEditor().setOpaque(true);
        this.getTextEditor().getEmptyText().setText(PyBundle.message("python.toolwindow.packages.search.text.placeholder", new Object[0]));
        this.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SingleAlarm.cancelAndRequest$default((SingleAlarm)this.getSearchAlarm(), (boolean)false, (int)1, null);
            }
        });
    }

    @NotNull
    public final PyPackagingToolWindowService getService() {
        return PyPackagingToolWindowService.Companion.getInstance(this.project);
    }

    @NotNull
    public final SingleAlarm getSearchAlarm() {
        return this.searchAlarm;
    }

    protected void onFieldCleared() {
        this.getService().handleSearch("");
    }

    private static final void searchAlarm$lambda$0(PyPackageSearchTextField this$0) {
        this$0.addCurrentTextToHistory();
        PyPackagingToolWindowService pyPackagingToolWindowService = this$0.getService();
        String string = this$0.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        pyPackagingToolWindowService.handleSearch(((Object)StringsKt.trim((CharSequence)string)).toString());
    }
}

