/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.PyTypeAssertionEvaluator;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCapturePattern;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyDoubleStarPattern;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValuePattern;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyMappingPattern;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySequencePattern;
import com.jetbrains.python.psi.PySingleStarPattern;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PySequencePatternImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCapturePatternImpl
extends PyElementImpl
implements PyCapturePattern {
    static Set<String> SPECIAL_BUILTINS = Set.of("bool", "bytearray", "bytes", "dict", "float", "frozenset", "int", "list", "set", "str", "tuple");

    public PyCapturePatternImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyCapturePattern(this);
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(0);
        }
        if (key == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(1);
        }
        return PyCapturePatternImpl.getCaptureType(this, context);
    }

    @Nullable
    static PyType getCaptureType(@NotNull PyPattern pattern, @NotNull TypeEvalContext context) {
        PyElement parentPattern;
        if (pattern == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(3);
        }
        if ((parentPattern = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)pattern, (Class[])new Class[]{PyCaseClause.class, PySingleStarPattern.class, PyDoubleStarPattern.class, PyKeyValuePattern.class, PySequencePattern.class, PyClassPattern.class, PyKeywordPattern.class})) instanceof PyCaseClause) {
            PyCaseClause caseClause = (PyCaseClause)parentPattern;
            PyMatchStatement matchStatement = PyUtil.as(caseClause.getParent(), PyMatchStatement.class);
            if (matchStatement == null) {
                return null;
            }
            PyExpression subject = matchStatement.getSubject();
            if (subject == null) {
                return null;
            }
            PyType subjectType = context.getType(subject);
            for (PyCaseClause cs : matchStatement.getCaseClauses()) {
                if (cs == caseClause) break;
                if (cs.getPattern() == null || cs.getGuardCondition() != null) continue;
                subjectType = (PyType)Ref.deref(PyTypeAssertionEvaluator.createAssertionType(subjectType, context.getType(cs.getPattern()), false, context));
            }
            return subjectType;
        }
        if (parentPattern instanceof PySingleStarPattern) {
            PySingleStarPattern starPattern = (PySingleStarPattern)parentPattern;
            PySequencePattern sequenceParent = PyUtil.as(starPattern.getParent(), PySequencePattern.class);
            if (sequenceParent == null) {
                return null;
            }
            PyType sequenceType = PySequencePatternImpl.getSequenceCaptureType(sequenceParent, context);
            PyType iteratedType = (PyType)PyTypeUtil.toStream(sequenceType).flatMap(it -> starPattern.getCapturedTypesFromSequenceType((PyType)it, context).stream()).collect(PyTypeUtil.toUnion());
            return PySequencePatternImpl.wrapInListType(iteratedType, (PsiElement)pattern);
        }
        if (parentPattern instanceof PyDoubleStarPattern) {
            PyMappingPattern mappingParent = PyUtil.as(parentPattern.getParent(), PyMappingPattern.class);
            if (mappingParent == null) {
                return null;
            }
            PyType parentType = context.getType(mappingParent);
            if (parentType instanceof PyCollectionType) {
                PyCollectionType collectionType = (PyCollectionType)parentType;
                PyClass dict = PyBuiltinCache.getInstance((PsiElement)pattern).getClass("dict");
                return dict != null ? new PyCollectionTypeImpl(dict, false, collectionType.getElementTypes()) : null;
            }
            return null;
        }
        if (parentPattern instanceof PyKeyValuePattern) {
            PyType mappingType;
            PyKeyValuePattern keyValuePattern = (PyKeyValuePattern)parentPattern;
            PyMappingPattern mappingParent = PyUtil.as(keyValuePattern.getParent(), PyMappingPattern.class);
            if (mappingParent == null) {
                return null;
            }
            PyType dictType = PyCapturePatternImpl.getCaptureType(mappingParent, context);
            if (dictType == null) {
                return null;
            }
            if (dictType instanceof PyTypedDictType) {
                PyLiteralType l;
                PyTypedDictType typedDictType = (PyTypedDictType)dictType;
                Object object = context.getType(keyValuePattern.getKeyPattern());
                if (object instanceof PyLiteralType && (object = (l = (PyLiteralType)object).getExpression()) instanceof PyStringLiteralExpression) {
                    PyStringLiteralExpression str = (PyStringLiteralExpression)object;
                    return typedDictType.getElementType(str.getStringValue());
                }
            }
            if ((mappingType = PyTypeUtil.convertToType(dictType, "typing.Mapping", (PsiElement)pattern, context)) instanceof PyCollectionType) {
                PyCollectionType collectionType = (PyCollectionType)mappingType;
                return collectionType.getElementTypes().get(1);
            }
            return null;
        }
        if (parentPattern instanceof PySequencePattern) {
            PySequencePattern sequencePattern = (PySequencePattern)parentPattern;
            PyType sequenceType = PySequencePatternImpl.getSequenceCaptureType(sequencePattern, context);
            if (sequenceType == null) {
                return null;
            }
            return (PyType)PyTypeUtil.toStream(sequenceType).map(it -> {
                PyTupleType tupleType;
                if (it instanceof PyTupleType && !(tupleType = (PyTupleType)it).isHomogeneous()) {
                    PsiElement sequenceMember = PsiTreeUtil.findFirstParent((PsiElement)pattern, el -> el.getParent() == sequencePattern);
                    List<PyPattern> elements = sequencePattern.getElements();
                    int idx = elements.indexOf(sequenceMember);
                    int starIdx = ContainerUtil.indexOf(elements, it2 -> it2 instanceof PySingleStarPattern);
                    if (starIdx == -1 || idx < starIdx) {
                        return tupleType.getElementType(idx);
                    }
                    int starSpan = tupleType.getElementCount() - elements.size();
                    return tupleType.getElementType(idx + starSpan);
                }
                PyType upcast = PyTypeUtil.convertToType(it, "typing.Sequence", (PsiElement)pattern, context);
                if (upcast instanceof PyCollectionType) {
                    PyCollectionType collectionType = (PyCollectionType)upcast;
                    return collectionType.getIteratedItemType();
                }
                return null;
            }).collect(PyTypeUtil.toUnion());
        }
        if (parentPattern instanceof PyClassPattern) {
            PyClassPattern classPattern = (PyClassPattern)parentPattern;
            PyType dictType = context.getType(classPattern);
            if (dictType instanceof PyClassType) {
                PyClassType classType = (PyClassType)dictType;
                List<PyPattern> arguments = classPattern.getArgumentList().getPatterns();
                int index = arguments.indexOf(pattern);
                if (index < 0) {
                    return null;
                }
                if (SPECIAL_BUILTINS.contains(classType.getClassQName())) {
                    if (index == 0) {
                        return context.getType(classPattern);
                    }
                    return null;
                }
                PyTargetExpression matchArgs = PyUtil.as(PyCapturePatternImpl.resolveTypeMember(classType, "__match_args__", context), PyTargetExpression.class);
                if (matchArgs == null) {
                    return null;
                }
                PyExpression matchArgsValue = PyPsiUtils.flattenParens(matchArgs.findAssignedValue());
                if (matchArgsValue instanceof PySequenceExpression) {
                    PySequenceExpression sequenceExpression = (PySequenceExpression)matchArgsValue;
                    if (sequenceExpression.getElements().length <= index) {
                        return null;
                    }
                    String attributeName = PyEvaluator.evaluate(sequenceExpression.getElements()[index], String.class);
                    if (attributeName == null) {
                        return null;
                    }
                    PyExpression instanceAttribute = PyUtil.as(PyCapturePatternImpl.resolveTypeMember(classType, attributeName, context), PyExpression.class);
                    if (instanceAttribute == null) {
                        return null;
                    }
                    return context.getType(instanceAttribute);
                }
            }
            return null;
        }
        if (parentPattern instanceof PyKeywordPattern) {
            PyKeywordPattern keywordPattern = (PyKeywordPattern)parentPattern;
            PyClassPattern classPattern = (PyClassPattern)PsiTreeUtil.getParentOfType((PsiElement)keywordPattern, PyClassPattern.class);
            if (classPattern == null) {
                return null;
            }
            PyType index = context.getType(classPattern);
            if (index instanceof PyClassType) {
                PyClassType classType = (PyClassType)index;
                PyExpression instanceAttribute = PyUtil.as(PyCapturePatternImpl.resolveTypeMember(classType, keywordPattern.getKeyword(), context), PyExpression.class);
                if (instanceAttribute == null) {
                    return null;
                }
                return context.getType(instanceAttribute);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type2 == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyCapturePatternImpl.$$$reportNull$$$0(6);
        }
        return !ContainerUtil.isEmpty(results = type2.resolveMember(name2, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) ? results.get(0).getElement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/PyCapturePatternImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCaptureType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveTypeMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

