/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.GeneratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSGenerator;
import com.oracle.truffle.js.runtime.builtins.JSGeneratorObject;
import com.oracle.truffle.js.runtime.objects.Completion;

public final class GeneratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<GeneratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new GeneratorPrototypeBuiltins();

    protected GeneratorPrototypeBuiltins() {
        super(JSGenerator.PROTOTYPE_NAME, GeneratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, GeneratorPrototype builtinEnum) {
        Completion.Type resumeMethod;
        assert (context2.getEcmaScriptVersion() >= 6);
        switch (builtinEnum.ordinal()) {
            case 0: {
                resumeMethod = Completion.Type.Normal;
                break;
            }
            case 1: {
                resumeMethod = Completion.Type.Return;
                break;
            }
            case 2: {
                resumeMethod = Completion.Type.Throw;
                break;
            }
            default: {
                return null;
            }
        }
        return GeneratorPrototypeBuiltinsFactory.GeneratorResumeNodeGen.create(context2, builtin, resumeMethod, GeneratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
    }

    public static enum GeneratorPrototype implements BuiltinEnum<GeneratorPrototype>
    {
        next(1),
        return_(1),
        throw_(1);

        private final int length;

        private GeneratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class GeneratorResumeNode
    extends JSBuiltinNode {
        private final Completion.Type resumeType;
        @Node.Child
        private PropertyGetNode getGeneratorTarget;
        @Node.Child
        private PropertyGetNode getGeneratorContext;
        @Node.Child
        private InternalCallNode callNode;

        public GeneratorResumeNode(JSContext context2, JSBuiltin builtin, Completion.Type resumeType) {
            super(context2, builtin);
            this.resumeType = resumeType;
            this.callNode = InternalCallNode.create();
        }

        @Specialization
        protected Object resume(JSGeneratorObject generator, Object value2) {
            CallTarget generatorTarget = generator.getGeneratorTarget();
            MaterializedFrame generatorContext = generator.getGeneratorContext();
            return this.callNode.execute(generatorTarget, JSArguments.createResumeArguments(generatorContext, generator, this.resumeType, value2));
        }

        @Fallback
        protected Object resume(Object thisObj, Object value2) {
            throw Errors.createTypeErrorGeneratorObjectExpected();
        }
    }
}

