/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeDownloadUtil;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.SemVer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService;", "", "<init>", "()V", "installExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "ensureInstalled", "", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "runWhenInstalled", "Ljava/util/function/Consumer;", "Companion", "Handler", "intellij.javascript.impl"})
@ApiStatus.Internal
public final class NodeJsDownloadService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService installExecutor;

    public NodeJsDownloadService() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"NodeJsInstaller", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.installExecutor = executorService;
    }

    public final void ensureInstalled(@Nullable Project project, @NotNull NodeJsInterpreter node, @NotNull Consumer<NodeJsInterpreter> runWhenInstalled) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(runWhenInstalled, (String)"runWhenInstalled");
        if (node instanceof NodeJsDownloadableInterpreter) {
            this.installExecutor.execute(() -> NodeJsDownloadService.ensureInstalled$lambda$0(project, node, runWhenInstalled));
        } else {
            runWhenInstalled.accept(node);
        }
    }

    private static final void ensureInstalled$lambda$0(Project $project, NodeJsInterpreter $node, Consumer $runWhenInstalled) {
        Handler.INSTANCE.installWithProgress$intellij_javascript_impl($project, (NodeJsDownloadableInterpreter)$node, $runWhenInstalled);
    }

    @NotNull
    public static final NodeJsDownloadService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService;", "getInstance$annotations", "getInstance", "()Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nNodeJsDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n40#2,3:81\n*S KotlinDebug\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Companion\n*L\n39#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeJsDownloadService getInstance() {
            boolean $i$f$service = false;
            Class<NodeJsDownloadService> serviceClass$iv = NodeJsDownloadService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (NodeJsDownloadService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0000\u00a2\u0006\u0002\b\rJ \u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Handler;", "", "<init>", "()V", "installWithProgress", "", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadableInterpreter;", "runWhenInstalled", "Ljava/util/function/Consumer;", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "installWithProgress$intellij_javascript_impl", "install", "downloadInterpreter", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nNodeJsDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,80:1\n15#2:81\n15#2:82\n*S KotlinDebug\n*F\n+ 1 NodeJsDownloadService.kt\ncom/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$Handler\n*L\n68#1:81\n74#1:82\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final void installWithProgress$intellij_javascript_impl(@Nullable Project project, @NotNull NodeJsDownloadableInterpreter node, @NotNull Consumer<NodeJsInterpreter> runWhenInstalled) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(runWhenInstalled, (String)"runWhenInstalled");
            Object[] objectArray = new Object[]{node};
            String string = JavaScriptBundle.message("node.js.downloading", objectArray);
            objectArray = Task.Backgroundable.ALWAYS_BACKGROUND;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, node, runWhenInstalled, string, (PerformInBackgroundOption)objectArray){
                final /* synthetic */ NodeJsDownloadableInterpreter $node;
                final /* synthetic */ Consumer<NodeJsInterpreter> $runWhenInstalled;
                {
                    this.$node = $node;
                    this.$runWhenInstalled = $runWhenInstalled;
                    super($project, $super_call_param$1, true, $super_call_param$2);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Handler.install(this.$node, this.$runWhenInstalled);
                }
            });
        }

        @JvmStatic
        public static final void install(@NotNull NodeJsDownloadableInterpreter node, @Nullable Consumer<NodeJsInterpreter> runWhenInstalled) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            try {
                NodeJsInterpreter interpreter2 = INSTANCE.downloadInterpreter(node);
                if (interpreter2 instanceof NodeJsLocalInterpreter) {
                    NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)nodeJsLocalInterpreterType, (String)"getInstance(...)");
                    NodeJsLocalInterpreterType type2 = nodeJsLocalInterpreterType;
                    List interpreters = new ArrayList(type2.getInterpreters());
                    if (!interpreters.contains(interpreter2)) {
                        interpreters.add(interpreter2);
                        type2.setInterpreters(interpreters);
                    }
                }
                if (runWhenInstalled != null && interpreter2 != null) {
                    ApplicationManager.getApplication().invokeLater(() -> Handler.install$lambda$0(runWhenInstalled, interpreter2));
                }
            }
            catch (IOException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(NodeJsDownloadService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot install Node.js interpreter: " + e.getMessage(), (Throwable)e);
            }
        }

        private final NodeJsInterpreter downloadInterpreter(NodeJsDownloadableInterpreter node) {
            SemVer semVer = (SemVer)node.getCachedVersion().get();
            if (semVer == null) {
                return null;
            }
            SemVer version2 = semVer;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(NodeJsDownloadService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Installing Node.js " + version2);
            Path installDirectory = Path.of(NodeDownloadUtil.INSTANCE.getDownloadLocation(version2), new String[0]);
            Intrinsics.checkNotNull((Object)installDirectory);
            PathKt.delete$default((Path)installDirectory, (boolean)false, (int)1, null);
            return NodeDownloadUtil.INSTANCE.downloadAndExtract(version2, installDirectory);
        }

        private static final void install$lambda$0(Consumer $runWhenInstalled, NodeJsInterpreter $interpreter) {
            $runWhenInstalled.accept($interpreter);
        }
    }
}

