/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDeprecatedSymbolsInspection
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSDeprecatedSymbolsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSDeprecatedSymbolsInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSVariable(@NotNull JSVariable node) {
                PsiElement identifier;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSVariable(node);
                if ((1.isDeprecatedDestructuring((PsiElement)node) || 1.isDeprecatedFromHierarchy((PsiElement)node)) && (identifier = node.getNameIdentifier()) != null) {
                    this.registerProblem(identifier, null, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                PsiElement identifier;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitJSFunctionDeclaration(node);
                if (1.isDeprecatedFromHierarchy(node) && (identifier = node.getNameIdentifier()) != null) {
                    this.registerProblem(identifier, null, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitJSProperty(@NotNull JSProperty node) {
                PsiElement identifier;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitJSProperty(node);
                if (1.isDeprecatedFromHierarchy((PsiElement)node) && (identifier = node.getNameIdentifier()) != null) {
                    this.registerProblem(identifier, null, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitES6ImportedExportedDefaultBinding(@NotNull ES6ImportedExportedDefaultBinding binding) {
                PsiElement deprecatedElement;
                Collection<PsiElement> referencedElements;
                PsiElement resolve2;
                if (binding == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((resolve2 = (PsiElement)ContainerUtil.getFirstItem(referencedElements = binding.findReferencedElements())) != null && referencedElements.size() == 1 && (deprecatedElement = 1.findDeprecatedElement(resolve2)) != null) {
                    this.registerProblem((PsiElement)binding, null, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
                if (specifier == null) {
                    1.$$$reportNull$$$0(4);
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)specifier, () -> this.doVisitES6ImportExportSpecifier(specifier));
            }

            private void doVisitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
                PsiElement deprecatedElement;
                PsiElement resolve2;
                if (specifier == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((resolve2 = specifier.resolve()) != null && (deprecatedElement = 1.findDeprecatedElement(resolve2)) != null) {
                    PsiElement aliasName;
                    ES6ImportExportSpecifierAlias alias = specifier.getAlias();
                    PsiElement psiElement = aliasName = alias == null ? null : alias.getNameIdentifier();
                    if (aliasName != null) {
                        this.registerProblem(aliasName, null, new LocalQuickFix[0]);
                    }
                    this.registerProblem((PsiElement)ObjectUtils.coalesce((Object)specifier.getReferenceNameElement(), (Object)specifier), null, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                PsiElement resolve2;
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((resolve2 = node.resolve()) == null) {
                    return;
                }
                if (JSResolveUtil.isSameReference(node, resolve2)) {
                    return;
                }
                if ((resolve2 = 1.findDeprecatedElement(resolve2)) == null) {
                    return;
                }
                String message = null;
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                if (resolve2 instanceof JSAttributeListOwner && ActionScriptPsiImplUtil.isDeprecatedFromAttribute((JSAttributeListOwner)resolve2)) {
                    String replacementString;
                    if ("caller".equals(node.getReferencedName()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                        return;
                    }
                    JSAttribute attribute = ((JSAttributeListOwner)resolve2).getAttributeList().findAttributeByName("Deprecated");
                    JSAttributeNameValuePair since = attribute.getValueByName("since");
                    JSAttributeNameValuePair replacement = attribute.getValueByName("replacement");
                    String string = replacementString = replacement != null ? replacement.getSimpleValue() : "unknown";
                    if (since != null || replacement != null) {
                        message = JavaScriptBundle.message("javascript.deprecated.symbol.used.name.message2", since != null ? since.getSimpleValue() : "unknown", replacementString);
                    } else {
                        JSAttributeNameValuePair messageAttr = attribute.getValueByName("message");
                        if (messageAttr != null && (message = messageAttr.getSimpleValue()) != null && message.trim().isEmpty()) {
                            message = null;
                        }
                    }
                    if (replacement != null) {
                        fixes = new LocalQuickFix[]{new LocalQuickFix(){

                            @NotNull
                            public String getName() {
                                String string = JavaScriptBundle.message("javascript.deprecated.symbol.replace.fix", replacementString);
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            @NotNull
                            public String getFamilyName() {
                                String string = JavaScriptBundle.message("javascript.deprecated.symbol.replace.fix.family", new Object[0]);
                                if (string == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return string;
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                if (descriptor == null) {
                                    1.$$$reportNull$$$0(3);
                                }
                                PsiElement psiElement = descriptor.getPsiElement();
                                PsiElement grandParent = (psiElement = psiElement.getParent()).getParent();
                                if (grandParent instanceof JSCallExpression) {
                                    psiElement = grandParent;
                                }
                                ((Navigatable)psiElement).navigate(false);
                                PsiElement finalPsiElement = psiElement;
                                WriteAction.run(() -> finalPsiElement.replace((PsiElement)JSPsiElementFactory.createJSExpression(replacementString, finalPsiElement)));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[switch (n) {
                                    default -> 2;
                                    case 2, 3 -> 3;
                                }];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "project";
                                        break;
                                    }
                                    case 3: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getName";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getFamilyName";
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        objectArray = objectArray;
                                        objectArray[2] = "applyFix";
                                        break;
                                    }
                                }
                                String string = String.format(v0, objectArray);
                                throw switch (n) {
                                    default -> new IllegalStateException(string);
                                    case 2, 3 -> new IllegalArgumentException(string);
                                };
                            }
                        }};
                    }
                }
                PsiElement referenceNameElement = node.getReferenceNameElement();
                assert (referenceNameElement != null) : node.getText();
                this.registerProblem(referenceNameElement, message, fixes);
            }

            private static PsiElement findDeprecatedElement(@NotNull PsiElement resolve2) {
                boolean isDeprecated;
                if (resolve2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!(isDeprecated = JSDocumentationUtils.isDeprecated(resolve2))) {
                    if ((resolve2 = JSStubBasedPsiTreeUtil.calculateTargetElement(resolve2)) instanceof JSObjectLiteralExpression) {
                        resolve2 = resolve2.getContext();
                    }
                    isDeprecated = JSDocumentationUtils.isDeprecated(resolve2) || 1.isDeprecatedDestructuring(resolve2);
                }
                return isDeprecated ? resolve2 : null;
            }

            private static boolean isDeprecatedDestructuring(@NotNull PsiElement resolve2) {
                if (resolve2 == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!(resolve2 instanceof JSFieldVariable)) {
                    return false;
                }
                PsiElement parent = resolve2.getParent();
                if (!(parent instanceof JSDestructuringShorthandedProperty)) {
                    return false;
                }
                JSDestructuringPropertyReference destructuringRef = (JSDestructuringPropertyReference)((Object)ContainerUtil.findInstance((Object[])parent.getReferences(), JSDestructuringPropertyReference.class));
                if (destructuringRef != null) {
                    resolve2 = destructuringRef.resolve();
                    return JSDocumentationUtils.isDeprecated(resolve2);
                }
                return false;
            }

            private static boolean isDeprecatedFromHierarchy(@NotNull PsiElement element) {
                Pair<JSClass, JSPsiElementBase> from;
                if (element == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (!(element instanceof JSQualifiedNamedElement)) {
                    return false;
                }
                JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)element;
                if (namedElement.isDeprecated()) {
                    return false;
                }
                if (JSClassUtils.isPossibleHierarchyMember(element)) {
                    Collection<JSPsiElementBase> members = JSInheritanceUtil.findImplementedMembers(namedElement);
                    if (!members.isEmpty()) {
                        return ContainerUtil.and(members, el -> el.isDeprecated());
                    }
                    JSPsiElementBase member = JSInheritanceUtil.findTopOverriddenMember(namedElement);
                    if (member != null) {
                        return member.isDeprecated();
                    }
                }
                return (from = JSInheritanceUtil.findSuperMembersFromContextType((JSPsiElementBase)element)) != null && ((JSPsiElementBase)from.second).isDeprecated();
            }

            private void registerProblem(@NotNull PsiElement place, @Nullable @InspectionMessage String message, LocalQuickFix ... fixes) {
                if (place == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (message == null) {
                    message = JavaScriptBundle.message("javascript.deprecated.symbol.used.name.message", new Object[0]);
                }
                holder.registerProblem(place, message, ProblemHighlightType.LIKE_DEPRECATED, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "binding";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "specifier";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resolve";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fixes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSProperty";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportedExportedDefaultBinding";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6ImportExportSpecifier";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doVisitES6ImportExportSpecifier";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReferenceExpression";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findDeprecatedElement";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDeprecatedDestructuring";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDeprecatedFromHierarchy";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSDeprecatedSymbolsInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

