/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLabelImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.agent.util.DockerJavaUtilsKt;
import com.intellij.docker.agent.util.DockerUtil;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DockerAgentContainerConfigImpl
implements DockerAgentContainerConfig {
    private final String[] myCommand;
    private final String[] myEntrypoint;
    private final Boolean myPublishAllPorts;
    private final DockerPortBinding[] myPortBindings;
    private final Integer[] myExposedPorts;
    private final DockerLink[] myLinks;
    private final DockerVolumeBinding[] myVolumeBindings;
    private final DockerEnvVar[] myEnvVars;
    private final String myWorkingDir;
    private final DockerVolumesFrom[] myVolumesFrom;
    private final Boolean myNetworkDisabled;
    private final String myNetworkMode;
    private final String[] myExtraHosts;
    private final String myContainerName;
    private final String myUser;
    private final DockerLabel[] myLabels;
    private final Boolean myStdinOnce;
    private final CreateContainerCmd myCmdConfig;

    DockerAgentContainerConfigImpl(DockerAgentContainerConfig source) {
        this.myCmdConfig = source.getContainerCmdConfig();
        this.myCommand = source.getCommand();
        this.myEntrypoint = source.getEntrypoint();
        this.myPortBindings = source.getPortBindings();
        this.myPublishAllPorts = source.getPublishAllPorts();
        this.myExposedPorts = source.getExposedPorts();
        this.myLinks = source.getLinks();
        this.myVolumeBindings = source.getVolumeBindings();
        this.myEnvVars = source.getEnvVars();
        this.myWorkingDir = source.getWorkingDir();
        this.myVolumesFrom = source.getVolumesFrom();
        this.myNetworkDisabled = source.getNetworkDisabled();
        this.myNetworkMode = source.getNetworkMode();
        this.myExtraHosts = source.getExtraHosts();
        this.myContainerName = source.getContainerName();
        this.myUser = source.getUser();
        this.myLabels = source.getLabels();
        this.myStdinOnce = source.getStdinOnce();
    }

    DockerAgentContainerConfigImpl(CreateContainerCmd cmd) {
        this.myCmdConfig = cmd;
        this.myCommand = cmd.getCmd();
        Optional<HostConfig> hostConfig = Optional.ofNullable(cmd.getHostConfig());
        this.myEntrypoint = cmd.getEntrypoint();
        this.myPublishAllPorts = hostConfig.map(HostConfig::getPublishAllPorts).orElse(null);
        this.myPortBindings = DockerJavaUtilsKt.getDockerPortBindings(cmd);
        this.myExposedPorts = DockerAgentContainerConfigImpl.createAgentExposedPorts(cmd.getExposedPorts());
        this.myLinks = DockerAgentContainerConfigImpl.createAgentLinks(hostConfig.map(HostConfig::getLinks).orElse(null));
        this.myVolumeBindings = DockerJavaUtilsKt.getVolumeBindings(cmd);
        this.myEnvVars = DockerJavaUtilsKt.getEnvVars(cmd);
        this.myWorkingDir = cmd.getWorkingDir();
        this.myVolumesFrom = DockerAgentContainerConfigImpl.createAgentVolumesFrom(hostConfig.map(HostConfig::getVolumesFrom).orElse(null));
        this.myNetworkDisabled = cmd.isNetworkDisabled();
        this.myNetworkMode = hostConfig.map(HostConfig::getNetworkMode).orElse(null);
        this.myExtraHosts = hostConfig.map(HostConfig::getExtraHosts).orElse(null);
        this.myContainerName = cmd.getName();
        this.myUser = cmd.getUser();
        this.myLabels = DockerAgentContainerConfigImpl.createAgentLabels(cmd.getLabels());
        this.myStdinOnce = cmd.isStdInOnce();
    }

    @Override
    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    @Override
    public String[] getCommand() {
        return this.myCommand;
    }

    @Override
    public String getContainerName() {
        return this.myContainerName;
    }

    @Override
    public String getUser() {
        return this.myUser;
    }

    @Override
    public DockerLabel[] getLabels() {
        return this.myLabels;
    }

    @Override
    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    @Override
    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    @Override
    public String[] getExtraHosts() {
        return this.myExtraHosts;
    }

    @Override
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    @Override
    public Boolean getNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    @Override
    public Boolean getPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    @Override
    public boolean isPublishAllPorts() {
        return Boolean.TRUE.equals(this.getPublishAllPorts());
    }

    @Override
    public DockerPortBinding[] getPortBindings() {
        return this.myPortBindings;
    }

    @Override
    public Integer[] getExposedPorts() {
        return this.myExposedPorts;
    }

    @Override
    public DockerLink[] getLinks() {
        return this.myLinks;
    }

    @Override
    public DockerVolumeBinding[] getVolumeBindings() {
        return this.myVolumeBindings;
    }

    @Override
    public DockerEnvVar[] getEnvVars() {
        return this.myEnvVars;
    }

    @Override
    public Boolean getStdinOnce() {
        return this.myStdinOnce;
    }

    @Override
    public CreateContainerCmd getContainerCmdConfig() {
        return this.myCmdConfig;
    }

    public PortBinding[] createCmdPortBindingsArray() {
        if (this.isPublishAllPorts()) {
            return new PortBinding[0];
        }
        if (this.myPortBindings == null) {
            return null;
        }
        return DockerUtil.mapArray(this.myPortBindings, PortBinding.class, source -> DockerJavaUtilsKt.toClientBinding(source));
    }

    public ExposedPort[] createCmdExposedPorts() {
        return DockerUtil.mapArray(this.myExposedPorts, ExposedPort.class, ExposedPort::new);
    }

    private static Integer[] createAgentExposedPorts(ExposedPort[] ports) {
        return DockerUtil.mapArray(ports, Integer.class, exposedPort -> exposedPort.getPort());
    }

    public Link[] createCmdLinks() {
        return DockerUtil.mapArray(this.myLinks, Link.class, source -> {
            String name2 = source.getName();
            String alias = source.getAlias();
            return new Link(name2, alias == null ? name2 : alias);
        });
    }

    private static DockerLink[] createAgentLinks(Link[] links) {
        return DockerUtil.mapArray(links, DockerLink.class, source -> {
            DockerLinkImpl result2 = new DockerLinkImpl();
            result2.setName(source.getName());
            result2.setAlias(source.getAlias());
            return result2;
        });
    }

    public VolumesFrom[] createCmdVolumesFrom() {
        return DockerUtil.mapArray(this.myVolumesFrom, VolumesFrom.class, source -> {
            String sourceContainerId = source.getContainerId();
            return sourceContainerId == null ? null : new VolumesFrom(sourceContainerId, AccessMode.fromBoolean(source.isReadOnly()));
        });
    }

    private static DockerVolumesFrom[] createAgentVolumesFrom(VolumesFrom[] volumesFroms) {
        return DockerUtil.mapArray(volumesFroms, DockerVolumesFrom.class, source -> new DockerVolumesFrom((VolumesFrom)source){
            final /* synthetic */ VolumesFrom val$source;
            {
                this.val$source = volumesFrom2;
            }

            @Override
            public String getContainerId() {
                return this.val$source.getContainer();
            }

            @Override
            public boolean isReadOnly() {
                return this.val$source.getAccessMode().toBoolean();
            }
        });
    }

    private static DockerLabel[] createAgentLabels(Map<String, String> links) {
        return links == null ? null : (DockerLabel[])links.entrySet().stream().map(DockerLabelImpl::from).toArray(DockerLabel[]::new);
    }
}

