/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.view.details.DockerLogConsoleView;
import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002+,B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u001c\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00072\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020\u0012H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/docker/view/details/DockerConsoleHolder;", "C", "Lcom/intellij/execution/ui/ConsoleView;", "Lcom/intellij/remoteServer/impl/runtime/log/LoggingHandlerBase;", "Lcom/intellij/remoteServer/runtime/log/LoggingHandler;", "Lcom/intellij/openapi/Disposable;", "title", "", "<init>", "(Ljava/lang/String;)V", "closed", "", "console", "getConsole", "()Lcom/intellij/execution/ui/ConsoleView;", "myAnsiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "print", "", "s", "printTextWithOutputKey", "text", "outputType", "Lcom/intellij/openapi/util/Key;", "addFilter", "filter", "Lcom/intellij/execution/filters/Filter;", "printHyperlink", "url", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "attachToProcess", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "clear", "scrollTo", "offset", "", "dispose", "getComponent", "Ljavax/swing/JComponent;", "isClosed", "close", "Default", "LogConsole", "intellij.clouds.docker"})
public abstract class DockerConsoleHolder<C extends ConsoleView>
extends LoggingHandlerBase
implements LoggingHandler,
Disposable {
    private volatile boolean closed;
    @NotNull
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;

    public DockerConsoleHolder(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(title);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
    }

    @NotNull
    public abstract C getConsole();

    public void print(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.myAnsiEscapeDecoder.escapeText(s, ProcessOutputTypes.STDOUT, this::printTextWithOutputKey);
    }

    private final void printTextWithOutputKey(String text, Key<?> outputType) {
        this.getConsole().print(text, ConsoleViewContentType.getConsoleViewType(outputType));
    }

    public final void addFilter(@NotNull Filter filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        this.getConsole().addMessageFilter(filter2);
    }

    public void printHyperlink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.printHyperlink(url, (HyperlinkInfo)new BrowserHyperlinkInfo(url));
    }

    public void printHyperlink(@NotNull String text, @Nullable HyperlinkInfo info) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.getConsole().printHyperlink(text, info);
    }

    public void attachToProcess(@NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.getConsole().attachToProcess(handler2);
    }

    public void clear() {
        this.getConsole().clear();
    }

    public void scrollTo(int offset) {
        this.getConsole().scrollTo(offset);
    }

    public void dispose() {
        this.close();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = ((ComponentContainer)this.getConsole()).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/view/details/DockerConsoleHolder$Default;", "Lcom/intellij/docker/view/details/DockerConsoleHolder;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "console", "getConsole", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "intellij.clouds.docker"})
    public static final class Default
    extends DockerConsoleHolder<ConsoleViewImpl> {
        @NotNull
        private final ConsoleViewImpl console;

        public Default(@NotNull String title, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(title);
            this.console = new ConsoleViewImpl(project, false);
            Disposer.register((Disposable)this, (Disposable)((Disposable)this.getConsole()));
        }

        @Override
        @NotNull
        public ConsoleViewImpl getConsole() {
            return this.console;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/view/details/DockerConsoleHolder$LogConsole;", "Lcom/intellij/docker/view/details/DockerConsoleHolder;", "Lcom/intellij/docker/view/details/DockerLogConsoleView;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "console", "getConsole", "()Lcom/intellij/docker/view/details/DockerLogConsoleView;", "intellij.clouds.docker"})
    public static final class LogConsole
    extends DockerConsoleHolder<DockerLogConsoleView> {
        @NotNull
        private final DockerLogConsoleView console;

        public LogConsole(@NotNull String title, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(title);
            this.console = new DockerLogConsoleView(project);
            Disposer.register((Disposable)this, (Disposable)((Disposable)this.getConsole()));
        }

        @Override
        @NotNull
        public DockerLogConsoleView getConsole() {
            return this.console;
        }
    }
}

