/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.templates.ref;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pyramid.annotator.PyramidTemplateLineMarkerProvider;
import com.intellij.python.pyramid.templates.psi.ChameleonAttribute;
import com.intellij.python.pyramid.templates.psi.ChameleonPsiElement;
import com.intellij.python.pyramid.templates.psi.ChameleonRepeat;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChameleonExprReference
extends PyReferenceImpl {
    @NonNls
    private static final String REPEATE_TEXT = "repeat";
    @NonNls
    private static final String REQUEST_TEXT = "request";

    public ChameleonExprReference(PyQualifiedExpression element, PyResolveContext context) {
        super(element, context);
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Object[] results = super.multiResolve(incompleteCode);
        ArrayList result = Lists.newArrayList((Object[])results);
        String text = this.myElement.getText();
        if (REPEATE_TEXT.equals(text)) {
            ChameleonAttribute parent = (ChameleonAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, ChameleonAttribute.class);
            if (parent != null) {
                ChameleonAttribute sibling = (ChameleonAttribute)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, ChameleonAttribute.class);
                while (sibling != null) {
                    ChameleonPsiElement content = sibling.getContent();
                    if (content instanceof ChameleonRepeat) {
                        result.add(new RatedResolveResult(0, (PsiElement)sibling));
                        break;
                    }
                    sibling = (ChameleonAttribute)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, ChameleonAttribute.class);
                }
            }
        } else if (REQUEST_TEXT.equals(text)) {
            PsiFile file = this.myElement.getContainingFile();
            Set<PyStringLiteralExpression> definitions = PyramidTemplateLineMarkerProvider.getRenderers(file);
            for (PyStringLiteralExpression string : definitions) {
                PyNamedParameter request2;
                PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)string, PyFunction.class);
                if (function == null || (request2 = function.getParameterList().findParameterByName(REQUEST_TEXT)) == null) continue;
                result.add(new RatedResolveResult(0, (PsiElement)request2));
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ChameleonExprReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/pyramid/templates/ref/ChameleonExprReference", "multiResolve"));
    }
}

