"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
var react_1 = __importStar(require("react"));
var index_1 = require("./index");
var helpers_1 = require("../helpers");
var SchemaContext = react_1.default.createContext({
    reverse: false,
    deepExpanded: false,
});
var Schema = function (_a) {
    var _b, _c, _d, _e, _f, _g;
    var schemaName = _a.schemaName, schema = _a.schema, _h = _a.required, required = _h === void 0 ? false : _h, _j = _a.isPatternProperty, isPatternProperty = _j === void 0 ? false : _j, _k = _a.isProperty, isProperty = _k === void 0 ? false : _k, _l = _a.isCircular, isCircular = _l === void 0 ? false : _l, dependentRequired = _a.dependentRequired, _m = _a.expanded, propExpanded = _m === void 0 ? false : _m, _o = _a.onlyTitle, onlyTitle = _o === void 0 ? false : _o, _p = _a.isArray, isArray = _p === void 0 ? false : _p;
    var _q = (0, react_1.useContext)(SchemaContext), reverse = _q.reverse, deepExpanded = _q.deepExpanded;
    var _r = (0, react_1.useState)(propExpanded || isArray), expanded = _r[0], setExpanded = _r[1];
    var _s = (0, react_1.useState)(false), deepExpand = _s[0], setDeepExpand = _s[1];
    (0, react_1.useEffect)(function () {
        if (!isArray) {
            setDeepExpand(deepExpanded);
        }
    }, [isArray, deepExpanded, setDeepExpand]);
    (0, react_1.useEffect)(function () {
        if (!isArray) {
            setExpanded(deepExpand);
        }
    }, [isArray, deepExpand, setExpanded]);
    if (!schema ||
        (typeof schemaName === 'string' &&
            ((schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-parser-')) ||
                (schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-schema-private-'))))) {
        return null;
    }
    var dependentSchemas = helpers_1.SchemaHelpers.getDependentSchemas(schema);
    var constraints = helpers_1.SchemaHelpers.humanizeConstraints(schema);
    var externalDocs = schema.externalDocs();
    var rawValueExt = schema.extensions().get(helpers_1.SchemaHelpers.extRawValue);
    var rawValue = (rawValueExt === null || rawValueExt === void 0 ? void 0 : rawValueExt.value()) === true;
    var parameterLocationExt = schema
        .extensions()
        .get(helpers_1.SchemaHelpers.extParameterLocation);
    var parameterLocation = (parameterLocationExt === null || parameterLocationExt === void 0 ? void 0 : parameterLocationExt.value()) === true;
    var schemaType = helpers_1.SchemaHelpers.toSchemaType(schema);
    var isExpandable = helpers_1.SchemaHelpers.isExpandable(schema) || dependentSchemas;
    isCircular = isCircular || schema.isCircular() || false;
    var uid = schema.$id();
    var styledSchemaName = isProperty ? 'italic' : '';
    var renderedSchemaName = typeof schemaName === 'string' ? (react_1.default.createElement("span", { className: "break-anywhere text-sm ".concat(styledSchemaName) }, schemaName)) : (schemaName);
    return (react_1.default.createElement(SchemaContext.Provider, { value: { reverse: !reverse, deepExpanded: deepExpand } },
        react_1.default.createElement("div", null,
            react_1.default.createElement("div", { className: "flex py-2" },
                react_1.default.createElement("div", { className: "".concat(onlyTitle ? '' : 'min-w-1/4', " mr-2") },
                    isExpandable && !isCircular && !isArray ? (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement(index_1.CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded }, renderedSchemaName),
                        react_1.default.createElement("button", { type: "button", onClick: function () { return setDeepExpand(function (prev) { return !prev; }); }, className: "ml-1 text-sm text-gray-500" }, deepExpand ? 'Collapse all' : 'Expand all'))) : (react_1.default.createElement("span", { className: "break-anywhere text-sm ".concat(isProperty ? 'italic' : '') }, schemaName)),
                    isPatternProperty && (react_1.default.createElement("div", { className: "text-gray-500 text-xs italic" }, "(pattern property)")),
                    required && react_1.default.createElement("div", { className: "text-red-600 text-xs" }, "required"),
                    dependentRequired && (react_1.default.createElement(react_1.default.Fragment, null,
                        react_1.default.createElement("div", { className: "text-gray-500 text-xs" }, "required when defined:"),
                        react_1.default.createElement("div", { className: "text-red-600 text-xs" }, dependentRequired.join(', ')))),
                    schema.deprecated() && (react_1.default.createElement("div", { className: "text-red-600 text-xs" }, "deprecated")),
                    schema.writeOnly() && (react_1.default.createElement("div", { className: "text-gray-500 text-xs" }, "write-only")),
                    schema.readOnly() && (react_1.default.createElement("div", { className: "text-gray-500 text-xs" }, "read-only"))),
                rawValue ? (react_1.default.createElement("div", null,
                    react_1.default.createElement("div", { className: "text-sm" }, helpers_1.SchemaHelpers.prettifyValue(schema.const(), false)))) : (react_1.default.createElement("div", null,
                    react_1.default.createElement("div", null,
                        react_1.default.createElement("div", { className: "capitalize text-sm text-teal-500 font-bold inline-block mr-2" }, isCircular ? "".concat(schemaType, " [CIRCULAR]") : schemaType),
                        react_1.default.createElement("div", { className: "inline-block" },
                            schema.format() && (react_1.default.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "format: ",
                                schema.format())),
                            schema.pattern() !== undefined && (react_1.default.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded mr-2 p-1 text-xs" },
                                "must match: ",
                                schema.pattern())),
                            schema.contentMediaType() !== undefined && (react_1.default.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "media type: ",
                                schema.contentMediaType())),
                            schema.contentEncoding() !== undefined && (react_1.default.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "encoding: ",
                                schema.contentEncoding())),
                            !!constraints.length &&
                                constraints.map(function (c) { return (react_1.default.createElement("strong", { className: "bg-purple-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs", key: c }, c)); }),
                            uid && !uid.startsWith('<anonymous-') && (react_1.default.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" },
                                "uid: ",
                                uid))),
                        schema.description() !== undefined && (react_1.default.createElement("div", null,
                            react_1.default.createElement(index_1.Markdown, null, schema.description()))),
                        schema.default() !== undefined && (react_1.default.createElement("div", { className: "text-xs" },
                            "Default value:",
                            react_1.default.createElement("span", { className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2" }, helpers_1.SchemaHelpers.prettifyValue(schema.default())))),
                        schema.const() !== undefined && (react_1.default.createElement("div", { className: "text-xs" },
                            "Const:",
                            react_1.default.createElement("span", { className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2" }, helpers_1.SchemaHelpers.prettifyValue(schema.const())))),
                        schema.enum() && (react_1.default.createElement("ul", { className: "text-xs" },
                            "Allowed values:",
                            ' ', (_b = schema.enum()) === null || _b === void 0 ? void 0 :
                            _b.map(function (e, idx) { return (react_1.default.createElement("li", { key: idx, className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2" },
                                react_1.default.createElement("span", null, helpers_1.SchemaHelpers.prettifyValue(e)))); }))),
                        parameterLocation && (react_1.default.createElement("div", { className: "text-xs" },
                            "Parameter location:",
                            ' ',
                            react_1.default.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" }, parameterLocation))),
                        externalDocs && (react_1.default.createElement("strong", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 no-underline text-xs uppercase rounded px-2 py-0" },
                            react_1.default.createElement(index_1.Href, { href: externalDocs.url(), title: (_c = externalDocs.description()) !== null && _c !== void 0 ? _c : '' }, "Documentation"))),
                        schema.examples() && (react_1.default.createElement("ul", { className: "text-xs" },
                            "Examples values:",
                            ' ', (_d = schema.examples()) === null || _d === void 0 ? void 0 :
                            _d.map(function (e, idx) { return (react_1.default.createElement("li", { key: idx, className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2 break-all" },
                                react_1.default.createElement("span", null, helpers_1.SchemaHelpers.prettifyValue(e)))); }))))))),
            isCircular || !isExpandable ? null : (react_1.default.createElement("div", { className: "rounded p-4 py-2 border bg-gray-100 ".concat(reverse ? 'bg-gray-200' : '', " ").concat(expanded ? 'block' : 'hidden') },
                react_1.default.createElement(SchemaProperties, { schema: schema }),
                react_1.default.createElement(SchemaItems, { schema: schema }), (_e = schema
                .oneOf()) === null || _e === void 0 ? void 0 :
                _e.map(function (s, idx) {
                    var _a;
                    return (react_1.default.createElement(exports.Schema, { key: idx, schema: s, schemaName: helpers_1.SchemaHelpers.applicatorSchemaName(idx, 'Adheres to', 'Or to', (_a = s.title()) !== null && _a !== void 0 ? _a : s.id()) }));
                }), (_f = schema
                .anyOf()) === null || _f === void 0 ? void 0 :
                _f.map(function (s, idx) {
                    var _a;
                    return (react_1.default.createElement(exports.Schema, { key: idx, schema: s, schemaName: helpers_1.SchemaHelpers.applicatorSchemaName(idx, 'Can adhere to', 'Or to', (_a = s.title()) !== null && _a !== void 0 ? _a : s.id()) }));
                }), (_g = schema
                .allOf()) === null || _g === void 0 ? void 0 :
                _g.map(function (s, idx) {
                    var _a;
                    return (react_1.default.createElement(exports.Schema, { key: idx, schema: s, schemaName: helpers_1.SchemaHelpers.applicatorSchemaName(idx, 'Consists of', 'And of', (_a = s.title()) !== null && _a !== void 0 ? _a : s.id()) }));
                }),
                schema.not() && (react_1.default.createElement(exports.Schema, { schema: schema.not(), schemaName: "Cannot adhere to:" })),
                schema.propertyNames() && (react_1.default.createElement(exports.Schema, { schema: schema.propertyNames(), schemaName: "Property names must adhere to:" })),
                schema.contains() && (react_1.default.createElement(exports.Schema, { schema: schema.contains(), schemaName: "Array must contain at least one of:" })),
                schema.if() && (react_1.default.createElement(exports.Schema, { schema: schema.if(), schemaName: "If schema adheres to:" })),
                schema.then() && (react_1.default.createElement(exports.Schema, { schema: schema.then(), schemaName: "Then must adhere to:" })),
                schema.else() && (react_1.default.createElement(exports.Schema, { schema: schema.else(), schemaName: "Otherwise:" })),
                dependentSchemas && (react_1.default.createElement(exports.Schema, { schema: dependentSchemas, schemaName: "Dependent schemas:" })),
                react_1.default.createElement(index_1.Extensions, { item: schema }),
                react_1.default.createElement(AdditionalProperties, { schema: schema }),
                react_1.default.createElement(AdditionalItems, { schema: schema }))))));
};
exports.Schema = Schema;
var SchemaProperties = function (_a) {
    var _b;
    var schema = _a.schema;
    var properties = schema.properties();
    if (properties === undefined || !Object.keys(properties)) {
        return null;
    }
    var required = (_b = schema.required()) !== null && _b !== void 0 ? _b : [];
    var patternProperties = schema.patternProperties();
    return (react_1.default.createElement(react_1.default.Fragment, null,
        Object.entries(properties).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (react_1.default.createElement(exports.Schema, { schema: property, schemaName: propertyName, required: required.includes(propertyName), isProperty: true, isCircular: property.isCircular(), dependentRequired: helpers_1.SchemaHelpers.getDependentRequired(propertyName, schema), key: propertyName }));
        }),
        Object.entries(patternProperties !== null && patternProperties !== void 0 ? patternProperties : {}).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (react_1.default.createElement(exports.Schema, { schema: property, schemaName: propertyName, isPatternProperty: true, isProperty: true, isCircular: property.isCircular(), key: propertyName }));
        })));
};
var AdditionalProperties = function (_a) {
    var _b;
    var schema = _a.schema;
    if (((_b = schema.extensions().get(helpers_1.SchemaHelpers.extRenderAdditionalInfo)) === null || _b === void 0 ? void 0 : _b.value()) ===
        false) {
        return null;
    }
    var type = schema.type();
    if (!(type === null || type === void 0 ? void 0 : type.includes('object'))) {
        return null;
    }
    var additionalProperties = schema.additionalProperties();
    if (additionalProperties === true || additionalProperties === undefined) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional properties are allowed."));
    }
    if (additionalProperties === false) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional properties are ",
            react_1.default.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return (react_1.default.createElement(exports.Schema, { schemaName: "Additional properties:", schema: additionalProperties }));
};
var SchemaItems = function (_a) {
    var _b;
    var schema = _a.schema;
    var type = schema.type();
    if (!(type === null || type === void 0 ? void 0 : type.includes('array'))) {
        return null;
    }
    var items = schema.items();
    if (items &&
        !Array.isArray(items) &&
        Object.keys((_b = items.properties()) !== null && _b !== void 0 ? _b : {}).length) {
        return react_1.default.createElement(exports.Schema, { schema: items, isArray: true });
    }
    else if (Array.isArray(items)) {
        return (react_1.default.createElement(react_1.default.Fragment, null, items.map(function (item, idx) { return (react_1.default.createElement(exports.Schema, { schema: item, isArray: true, schemaName: "".concat(idx + 1, " item:"), key: idx })); })));
    }
    return react_1.default.createElement(exports.Schema, { schema: items, isArray: true, schemaName: "Items:" });
};
var AdditionalItems = function (_a) {
    var _b;
    var schema = _a.schema;
    if (((_b = schema.extensions().get(helpers_1.SchemaHelpers.extRenderAdditionalInfo)) === null || _b === void 0 ? void 0 : _b.value()) ===
        false) {
        return null;
    }
    var type = schema.type();
    if (!(type === null || type === void 0 ? void 0 : type.includes('array'))) {
        return null;
    }
    if (!Array.isArray(schema.items())) {
        return null;
    }
    var additionalItems = schema.additionalItems();
    if (additionalItems === true || additionalItems === undefined) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional items are allowed."));
    }
    if (additionalItems === false) {
        return (react_1.default.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional items are ",
            react_1.default.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return react_1.default.createElement(exports.Schema, { schemaName: "Additional items:", schema: additionalItems });
};
//# sourceMappingURL=Schema.js.map