import type { GetOffsetFn } from './types';
/** Any valid CSS string value
 * @example `calc(var(--grid) * 2)
 */
type CSSValue = string;
/**
 * Position the native drag preview **in front** of the users pointer.
 *
 * **Distance**
 *
 * If the total width of your preview (including the offset applied by this function)
 * exceeds `280px` then the drag preview will have more opacity applied on Windows.
 *
 * https://atlassian.design/components/pragmatic-drag-and-drop/web-platform-design-constraints
 *
 * **Direction**
 *
 * This function will position the drag preview on the _right hand side for left to right (`ltr`) interfaces_, and on the _left hand side for right to left (`rtl`) languages_.
 *
 * The direction will be calculated based on the direction (`dir`) being applied to the `container`
 * element (which will be a child of the `body` element).
 *
 * **iOS**
 *
 * This function will not push the preview away from the users pointer on iOS due to platform limitations.
 * On iOS the preview will start the drag on the top left corner (or top right corner for right to left interfaces).
 * While dragging, iOS will shift the drag preview under the center of the users pointer, so the "pushing away"
 * is short lived on iOS.
 */
export declare function pointerOutsideOfPreview(point: {
    x: CSSValue;
    y: CSSValue;
}): GetOffsetFn;
export {};
