/************************************************************/
/*                                                          */
/* Module ID  - idmain.c                                    */
/*                                                          */
/* Function   - Allow privileged caller to invoke diagnose  */
/*              0 to return identifying information.        */
/*                                                          */
/* Called By  - N/A.                                        */
/*                                                          */
/* Calling To - N/A.                                        */
/*                                                          */
/* Parameters - See individual entry points.                */
/*                                                          */
/* Notes      - (1) Code published under GPL. Copyright     */
/*                  Neale Ferguson, Sterling Software.      */
/*                                                          */
/*                                                          */
/* Name       - Neale Ferguson.                             */
/*                                                          */
/* Date       - January, 2004.                              */
/*                                                          */
/*                                                          */
/* Associated    - (1) Refer To ........................... */
/* Documentation                                            */
/*                 (2) Refer To ........................... */
/*                                                          */
/************************************************************/

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#ifndef __KERNEL__
#  define __KERNEL__
#endif
#ifndef MODULE
#  define MODULE
#endif

#define __NO_VERSION__		/* don't define kernel_verion in module.h */

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              INCLUDE STATEMENTS                          */
/*              ------------------                          */
/*                                                          */
/************************************************************/

#include <linux/module.h>
#include <linux/version.h>

#include <linux/kernel.h>	/* printk() */
#include <linux/slab.h>		/* kmalloc() */
#include <linux/fs.h>		/* everything... */
#include <linux/errno.h>	/* error codes */
#include <linux/types.h>	/* size_t */
#include <linux/proc_fs.h>
#include <linux/fcntl.h>	/* O_ACCMODE */

#include <asm/system.h>		/* cli(), *_flags */
#include <asm/segment.h>	/* memcpy and such */
#include <asm/ebcdic.h>		/* ebcdic stuff */
#include <asm/uaccess.h>	/* copy to/from user space */

#include "cpint.h"		/* local definitions */
#include "idcmd.h"		/* specific definitions */

/*================== End of Include Statements =============*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - idcmd_open.                                 */
/*                                                          */
/* Function   - Open the CP identity device.                */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
idcmd_open(struct inode *inode, struct file *filp)
{
	int num = MINOR(inode->i_rdev);
	CPInt_Dev *dev;
	IDCmd_Dev *devExt;

	if (num >= cpint_nr_devs)
		return -ENODEV;

	dev = &cpint_devices[num];

	devExt = kmalloc(sizeof (IDCmd_Dev), GFP_KERNEL | __GFP_REPEAT);

	if (!devExt)
		return -ENOMEM;

	memset(devExt, 0, sizeof (IDCmd_Dev));
	devExt->dev = dev;

    /*--------------------------------------------------*/
	/* use filp->private_data to point to device data   */
    /*--------------------------------------------------*/
	filp->private_data = devExt;

	return 0;
}

/*===================== End of Function ====================*/

/************************************************************/
/*                                                          */
/* Name       - idcmd_release.                              */
/*                                                          */
/* Function   - Close a device.                             */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
idcmd_release(struct inode *inode, struct file *filp)
{
	IDCmd_Dev *devExt = filp->private_data;

	kfree(devExt);

	return (0);
}

/*===================== End of Function ====================*/

/************************************************************/
/*                                                          */
/* Name       - idcmd_ctl.                                  */
/*                                                          */
/* Function   - Perform IOCTL functions for ID interface:   */
/*		1. Issue DIAG 0 and return the data back    */
/*                 to the user.   			    */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*              cmd   - Command to be issued.               */
/*              arg   - Argument.                           */
/*                                                          */
/************************************************************/

int
idcmd_ioctl(struct inode *inode, struct file *filp,
	    unsigned int cmd, unsigned long arg)
{
	IDCmd_Dev *devExt = filp->private_data;
	union {
		long long x;
		char buffer[40];
	} diag0_buffer;

	if (devExt != NULL) {
		switch (cmd) {
		case IDGETBF:	/* Return the diag 0 buffer */
#ifdef __s390x__
		      __asm__("LRAG  2,0%0\t/* Get buffer address */\n\t" "LHI   3,40\t/* Get length of buffer */\n\t" "SAM31\t/* Get into 31-bit mode */\n\t" ".long 0x83230000\t/* Issue command */\n\t" "SAM64\t/* Resume 64-bit mode */\n\t" "LR    %1,3\t/* Get n'bytes left */\n": "+m"(diag0_buffer), "=r"(devExt->rc):
		      :"2", "3");
#else
		      __asm__("LRA   2,%0\t/* Get buffer address */\n\t" "LHI   3,40\t/* Get length of command */\n\t" ".long 0x83230000\t/* Issue command */\n\t" "LR    %1,3\t/* Get n'bytes left */\n": "+m"(diag0_buffer), "=r"(devExt->rc):
		      :"2", "3");
#endif
			if (devExt->rc == 0) {
				if (copy_to_user((char *) arg,
						 diag0_buffer.buffer,
						 sizeof (diag0_buffer)))
					return -EFAULT;
				else
					return 0;
			} else
				return -EFAULT;
			break;

		default:
			return -EINVAL;
		}
	} else
		return -ENODEV;

}

/*===================== End of Function ====================*/
