/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Housekeeper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class UninstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257281444152684850L;
    private IconsDatabase icons;
    protected static LocaleDatabase langpack;
    protected JCheckBox targetDestroyCheckbox;
    protected JProgressBar progressBar;
    protected JButton destroyButton;
    protected JButton quitButton;
    private Color buttonsHColor = new Color(230, 230, 230);
    protected String installPath;

    public UninstallerFrame(boolean bl, boolean bl2) throws Exception {
        String string;
        langpack = new LocaleDatabase(UninstallerFrame.class.getResourceAsStream("/langpack.xml"));
        InputStream inputStream = UninstallerFrame.class.getResourceAsStream("/customlangpack.xml");
        if (inputStream != null) {
            langpack.add(inputStream);
        }
        if (null == (string = langpack.getString("uninstaller.title")) || "uninstaller.title".equals(string)) {
            string = "IzPack - Uninstaller";
        }
        this.setTitle(string);
        this.getInstallPath();
        this.icons = new IconsDatabase();
        this.loadIcons();
        UIManager.put("OptionPane.yesButtonText", langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", langpack.getString("installer.cancel"));
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        this.buildGUI(bl, bl2);
        this.addWindowListener(new WindowHandler());
        this.pack();
        this.centerFrame(this);
        this.setResizable(true);
        this.setVisible(true);
    }

    private void buildGUI(boolean bl, boolean bl2) {
        JPanel jPanel = (JPanel)this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ActionsHandler actionsHandler = new ActionsHandler();
        JPanel jPanel2 = (JPanel)this.getGlassPane();
        jPanel2.addMouseListener(new MouseAdapter(){});
        jPanel2.addMouseMotionListener(new MouseMotionAdapter(){});
        jPanel2.addKeyListener(new KeyAdapter(){});
        ButtonFactory.useButtonIcons();
        ButtonFactory.useHighlightButtons();
        JLabel jLabel = new JLabel(langpack.getString("uninstaller.warning"), this.icons.getImageIcon("warning"), 11);
        this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 1.0, 0.0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagLayout.addLayoutComponent(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.targetDestroyCheckbox = new JCheckBox(langpack.getString("uninstaller.destroytarget") + this.installPath, bl2);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 1.0, 0.0);
        gridBagLayout.addLayoutComponent(this.targetDestroyCheckbox, gridBagConstraints);
        if (bl) {
            jPanel.add(this.targetDestroyCheckbox);
        }
        gridBagConstraints.fill = 2;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(langpack.getString("InstallPanel.begin"));
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 1.0, 0.0);
        gridBagLayout.addLayoutComponent(this.progressBar, gridBagConstraints);
        jPanel.add(this.progressBar);
        this.destroyButton = ButtonFactory.createButton(langpack.getString("uninstaller.uninstall"), this.icons.getImageIcon("delete"), this.buttonsHColor);
        this.destroyButton.addActionListener(actionsHandler);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0.5, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.addLayoutComponent(this.destroyButton, gridBagConstraints);
        jPanel.add(this.destroyButton);
        this.quitButton = ButtonFactory.createButton(langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.buttonsHColor);
        this.quitButton.addActionListener(actionsHandler);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 0.5, 0.0);
        gridBagConstraints.anchor = 13;
        gridBagLayout.addLayoutComponent(this.quitButton, gridBagConstraints);
        jPanel.add(this.quitButton);
    }

    private void centerFrame(Window window) {
        Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension dimension = window.getSize();
        window.setLocation(point.x - dimension.width / 2, point.y - dimension.height / 2 - 10);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    private void getInstallPath() throws Exception {
        InputStream inputStream = UninstallerFrame.class.getResourceAsStream("/install.log");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.installPath = bufferedReader.readLine();
        bufferedReader.close();
    }

    private void loadIcons() throws Exception {
        this.icons = new IconsDatabase();
        URL uRL = UninstallerFrame.class.getResource("/img/trash.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.icons.put("delete", imageIcon);
        uRL = UninstallerFrame.class.getResource("/img/stop.png");
        imageIcon = new ImageIcon(uRL);
        this.icons.put("stop", imageIcon);
        uRL = UninstallerFrame.class.getResource("/img/flag.png");
        imageIcon = new ImageIcon(uRL);
        this.icons.put("warning", imageIcon);
        uRL = UninstallerFrame.class.getResource("/img/JFrameIcon.png");
        imageIcon = new ImageIcon(uRL);
        this.icons.put("JFrameIcon", imageIcon);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static LocaleDatabase getLangpack() {
        return langpack;
    }

    class ActionsHandler
    implements ActionListener {
        ActionsHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == UninstallerFrame.this.quitButton) {
                Housekeeper.getInstance().shutDown(0);
            } else if (object == UninstallerFrame.this.destroyButton) {
                UninstallerFrame.this.destroyButton.setEnabled(false);
                Destroyer destroyer = new Destroyer(UninstallerFrame.this.installPath, UninstallerFrame.this.targetDestroyCheckbox.isSelected(), new DestroyerHandler());
                destroyer.start();
            }
        }
    }

    private final class DestroyerHandler
    implements AbstractUIProgressHandler {
        private DestroyerHandler() {
        }

        public void startAction(String string, final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UninstallerFrame.this.progressBar.setMinimum(0);
                    UninstallerFrame.this.progressBar.setMaximum(n);
                    UninstallerFrame.this.blockGUI();
                }
            });
        }

        public void stopAction() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UninstallerFrame.this.progressBar.setString(langpack.getString("InstallPanel.finished"));
                    UninstallerFrame.this.targetDestroyCheckbox.setEnabled(false);
                    UninstallerFrame.this.destroyButton.setEnabled(false);
                    UninstallerFrame.this.releaseGUI();
                }
            });
        }

        public void progress(final int n, final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UninstallerFrame.this.progressBar.setValue(n);
                    UninstallerFrame.this.progressBar.setString(string);
                }
            });
        }

        public void nextStep(String string, int n, int n2) {
        }

        public void setSubStepNo(int n) {
        }

        public void emitNotification(String string) {
        }

        public boolean emitWarning(String string, String string2) {
            return JOptionPane.showConfirmDialog(null, string2, string, 2, 2) == 0;
        }

        public void emitError(String string, String string2) {
            UninstallerFrame.this.progressBar.setString(string2);
            JOptionPane.showMessageDialog(null, string2, string, 2);
        }

        public void emitErrorAndBlockNext(String string, String string2) {
            this.emitError(string, string2);
        }

        public int askQuestion(String string, String string2, int n) {
            return this.askQuestion(string, string2, n, -1);
        }

        public int askQuestion(String string, String string2, int n, int n2) {
            int n3 = 0;
            if (n == 37) {
                n3 = 0;
            } else if (n == 38) {
                n3 = 1;
            }
            int n4 = JOptionPane.showConfirmDialog(null, string2, string, n3, 3);
            if (n4 == 2) {
                return 45;
            }
            if (n4 == 0) {
                return 47;
            }
            if (n4 == 1) {
                return 49;
            }
            return n2;
        }
    }

    private final class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Housekeeper.getInstance().shutDown(0);
        }
    }
}

