//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// Hadronic Process: Nuclear De-excitations
// by V. Lara
//
// Modified:
// 21.03.2013 V.Ivanchenko redesigned and cleaned up


#ifndef G4CameronGilbertPairingCorrections_h
#define G4CameronGilbertPairingCorrections_h 1

#include "globals.hh"

class G4CameronGilbertPairingCorrections
{
public:

  G4CameronGilbertPairingCorrections();

  ~G4CameronGilbertPairingCorrections() = default;

  G4bool GetPairingCorrection(G4int N, G4int Z, G4double& result) const
  {
    G4bool res = false;
    if (Z >= TableMin && Z <= ZTableMax && N >= TableMin && N <= NTableMax) { 
      result = PairingZTable[Z - TableMin] + PairingNTable[N - TableMin];
      res = true; 
    }
    return res;
  }

  G4CameronGilbertPairingCorrections(const G4CameronGilbertPairingCorrections& right) = delete;
  const G4CameronGilbertPairingCorrections& operator=
  (const G4CameronGilbertPairingCorrections& right) = delete;

private:

  const G4int TableMin{11};
  const G4int ZTableMax{98};
  const G4int NTableMax{150};
  static const G4int ZTableSize{88};
  static const G4int NTableSize{140};

  static G4double PairingZTable[ZTableSize];
  static G4double PairingNTable[NTableSize];
	
};
#endif
