/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '__scm_send' function
 *
 * Notes:
 *  - This hook enforces process validation
 *    before SCM_CREDENTIALS is used (for UNIX sockets).
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 28.IV.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SCM_SEND_H
#define P_LKRG_EXPLOIT_DETECTION_SCM_SEND_H

/* per-instance private data */
struct p_scm_send_data {
    ktime_t entry_stamp;
};


int p_scm_send_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_scm_send_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_scm_send_hook(int p_isra);
void p_uninstall_scm_send_hook(void);

#endif
